/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.java.queries.GradleScope;
import org.netbeans.modules.gradle.java.queries.GradleScopes;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.Scopes;

public final class GradleScopesBuilder {
    private static final Map<String, String> REMAP_ABSTRACT_SCOPES = new HashMap<String, String>();
    private final Project project;
    private final GradleBaseProject gbp;
    private Map<String, Collection<String>> extendsFrom = new HashMap<String, Collection<String>>();
    private Map<String, Collection<String>> inheritedInto = new HashMap<String, Collection<String>>();
    Map<String, GradleScope> scopes = new HashMap<String, GradleScope>();
    private Map<String, GS> scopeData = new HashMap<String, GS>();

    public GradleScopesBuilder(Project project) {
        this.project = project;
        this.gbp = GradleBaseProject.get((Project)project);
    }

    private void addToMap(Map<String, Collection<String>> map, String k, String c) {
        map.computeIfAbsent(k, n -> new LinkedHashSet(2)).add(c);
    }

    private void addDependency(String inheritedTo, String inheritedFrom) {
        this.addToMap(this.extendsFrom, inheritedTo, inheritedFrom);
        this.addToMap(this.inheritedInto, inheritedFrom, inheritedTo);
    }

    private GradleScope createMetaScope(String metaName, String config, String targetConfig) {
        GS gs = new GS();
        this.scopeData.put(metaName, gs);
        this.addDependency(metaName, config);
        GradleScope s = new GradleScope(metaName, config, targetConfig, gs.extendsFrom, gs.inheritedInto);
        this.scopes.put(metaName, s);
        return s;
    }

    public GradleScopes build() {
        for (String cfg : this.gbp.getConfigurations().keySet()) {
            GradleConfiguration c = (GradleConfiguration)this.gbp.getConfigurations().get(cfg);
            c.getExtendsFrom().forEach(p -> this.addDependency(cfg, p.getName()));
        }
        this.addDependency(Scopes.EXTERNAL.name(), "compileOnly");
        this.addDependency(Scopes.PROCESS.name(), "annotationProcessor");
        this.addDependency(Scopes.COMPILE.name(), "compileClasspath");
        this.addDependency(Scopes.RUNTIME.name(), "runtimeClasspath");
        this.addDependency(Scopes.TEST_COMPILE.name(), "testCompileClasspath");
        this.addDependency(Scopes.TEST_RUNTIME.name(), "testRuntimeClasspath");
        this.addDependency(Scopes.TEST.name(), Scopes.TEST_RUNTIME.name() + "," + Scopes.TEST_COMPILE.name());
        for (String cfg : this.gbp.getConfigurations().keySet()) {
            GS gs = new GS();
            this.scopeData.put(cfg, gs);
            this.scopes.put(cfg, new GradleScope(cfg, gs.extendsFrom, gs.inheritedInto));
        }
        this.createMetaScope(Scopes.EXTERNAL.name(), "compileOnly", "compileOnly");
        this.createMetaScope(Scopes.PROCESS.name(), "annotationProcessor", "annotationProcessor");
        this.createMetaScope(Scopes.COMPILE.name(), "compileClasspath", "implementation");
        this.createMetaScope(Scopes.RUNTIME.name(), "runtimeClasspath", "runtimeOnly");
        this.createMetaScope(Scopes.TEST_COMPILE.name(), "testCompileClasspath", "testCompileClasspath");
        this.createMetaScope(Scopes.TEST_RUNTIME.name(), "testRuntimeClasspath", "testRuntimeClasspath");
        this.createMetaScope(Scopes.TEST.name(), "testCompileClasspath", "testImplementation");
        for (GradleScope gs : this.scopes.values()) {
            GS data = this.scopeData.get(gs.name());
            ((Collection)this.extendsFrom.getOrDefault(gs.name(), Collections.emptyList())).stream().map(this.scopes::get).filter(Objects::nonNull).forEach(data.extendsFrom::add);
            ((Collection)this.inheritedInto.getOrDefault(gs.name(), Collections.emptyList())).stream().map(this.scopes::get).filter(Objects::nonNull).forEach(data.inheritedInto::add);
        }
        return new GradleScopes(this.project, this.scopes);
    }

    static {
        REMAP_ABSTRACT_SCOPES.put(Scopes.COMPILE.name(), "compileClasspath");
        REMAP_ABSTRACT_SCOPES.put(Scopes.RUNTIME.name(), "runtimeClasspath");
        REMAP_ABSTRACT_SCOPES.put(Scopes.TEST_COMPILE.name(), "testCompileClasspath");
        REMAP_ABSTRACT_SCOPES.put(Scopes.TEST_RUNTIME.name(), "testRuntimeClasspath");
        REMAP_ABSTRACT_SCOPES.put(Scopes.TEST.name(), Scopes.TEST_RUNTIME.name() + "," + Scopes.TEST_COMPILE.name() + ",testRuntimeClasspath,testCompileClasspath");
    }

    static class GS {
        Set<Scope> extendsFrom = new HashSet<Scope>();
        Set<Scope> inheritedInto = new HashSet<Scope>();

        GS() {
        }
    }
}

