/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.queries.DependencyText;
import org.netbeans.modules.gradle.java.queries.GradleScopes;
import org.netbeans.modules.gradle.java.queries.TextDependencyScanner;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.Dependency;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectScopes;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class GradleDependencyResult
implements DependencyResult,
PropertyChangeListener {
    private final NbGradleProject gp;
    private final Project gradleProject;
    private final Dependency root;
    private boolean valid = true;
    private final GradleScopes scopes;
    PropertyChangeListener wL;
    private List<ChangeListener> listeners;
    private List<ChangeListener> sourceListeners;
    private Collection<ArtifactSpec> problems;
    private Map<FileObject, DW> documentWatchers = new HashMap<FileObject, DW>();
    private final FileObject projectFile;
    private DependencyText.Mapping sourceMapping;

    public GradleDependencyResult(Project gradleProject, GradleScopes scopes, Dependency root) {
        this.gradleProject = gradleProject;
        this.scopes = scopes;
        this.root = root;
        this.gp = NbGradleProject.get((Project)gradleProject);
        File bs = this.gp.getGradleFiles().getBuildScript();
        this.projectFile = bs == null ? null : FileUtil.toFileObject((File)this.gp.getGradleFiles().getBuildScript());
    }

    public Project getProject() {
        return this.gradleProject;
    }

    public Dependency getRoot() {
        return this.root;
    }

    public boolean isValid() {
        return this.valid;
    }

    public ProjectScopes getScopes() {
        return this.scopes;
    }

    public Collection<ArtifactSpec> getProblemArtifacts() {
        return Collections.unmodifiableCollection(this.problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ChangeListener>();
                this.wL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.gradleProject);
                NbGradleProject.addPropertyChangeListener((Project)this.gradleProject, (PropertyChangeListener)this.wL);
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
                NbGradleProject.removePropertyChangeListener((Project)this.gradleProject, (PropertyChangeListener)this.wL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ArrayList<ChangeListener> ll;
        if (!"ProjectInfo".equals(evt.getPropertyName())) {
            return;
        }
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            this.valid = false;
            this.sourceMapping = null;
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            ll = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    static DependencyText.Mapping computeTextMappings(NbGradleProject gp, GradleBaseProject gbp, List<Dependency> children, boolean matchScopes) throws IOException {
        Set<String> cfgNames = gbp.getConfigurations().keySet();
        TextDependencyScanner ts = new TextDependencyScanner(matchScopes).withConfigurations(cfgNames);
        children.forEach(rd -> {
            Info info = (Info)rd.getProjectData();
            GradleConfiguration org = info.config.getDependencyOrigin(info.gradleDependency);
            if (org == null) {
                org = info.config;
            }
            ts.addDependencyOrigin(info.gradleDependency, org.getName());
        });
        String contents = null;
        FileObject projectFile = FileUtil.toFileObject((File)gp.getGradleFiles().getBuildScript());
        if (projectFile != null) {
            StyledDocument doc;
            EditorCookie cake = null;
            cake = (EditorCookie)projectFile.getLookup().lookup(EditorCookie.class);
            if (cake != null && (doc = cake.getDocument()) != null) {
                String[] docContent = new String[1];
                doc.render(() -> {
                    try {
                        docContent[0] = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                });
            }
        }
        if (contents == null) {
            contents = projectFile.asText();
        }
        ts.parseDependencyList(contents);
        return ts.mapDependencies(children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceLocation getDeclarationRange(Dependency d, String part) throws IOException {
        DependencyText.Mapping mapping;
        Object p = null;
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            mapping = this.sourceMapping;
            if (mapping != null) {
                return this.getDeclarationRange0(mapping, d, part);
            }
        }
        mapping = GradleDependencyResult.computeTextMappings(this.gp, GradleBaseProject.get((Project)this.gradleProject), this.root.getChildren(), false);
        gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (this.sourceMapping == null) {
                this.sourceMapping = mapping;
            }
        }
        return this.getDeclarationRange0(mapping, d, part);
    }

    private SourceLocation getDeclarationRange0(DependencyText.Mapping mapping, Dependency d, String part) {
        DependencyText.Part found;
        Dependency direct = d;
        if (d != null) {
            while (direct.getParent() != null && direct.getParent() != this.root) {
                direct = direct.getParent();
            }
        }
        if ((found = mapping.getText(direct == this.root ? null : direct, part)) == null) {
            return null;
        }
        return this.partToLocation(direct == d ? null : direct, found);
    }

    private SourceLocation partToLocation(Dependency rootDep, DependencyText.Part p) {
        return new SourceLocation(this.projectFile, p.startPos, p.endPos, (Object)rootDep);
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public Collection<FileObject> getDependencyFiles() {
        File f = this.gp.getGradleFiles().getBuildScript();
        if (f == null) {
            return Collections.emptyList();
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        return fo == null ? Collections.emptyList() : Collections.singletonList(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceChangeListener(ChangeListener l) {
        FileObject fo;
        boolean attach = false;
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (this.sourceListeners == null) {
                this.sourceListeners = new ArrayList<ChangeListener>();
                attach = true;
            }
            this.sourceListeners.add(l);
        }
        if (attach && (fo = FileUtil.toFileObject((File)this.gp.getGradleFiles().getBuildScript())) != null) {
            this.addDocumentWatcher(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceChangeListener(ChangeListener l) {
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (this.sourceListeners == null || this.sourceListeners.isEmpty()) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentWatcher(FileObject f) {
        DW dw;
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            if (f == null || this.documentWatchers.containsKey(f)) {
                return;
            }
        }
        EditorCookie cake = (EditorCookie)f.getLookup().lookup(EditorCookie.class);
        StyledDocument doc = null;
        if (cake != null) {
            doc = cake.getDocument();
        }
        GradleDependencyResult gradleDependencyResult2 = this;
        synchronized (gradleDependencyResult2) {
            if (this.documentWatchers.containsKey(f)) {
                return;
            }
            dw = new DW(f, doc);
            this.documentWatchers.put(f, dw);
        }
        if (doc != null) {
            doc.addDocumentListener((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)dw, (Object)doc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void documentChanged(FileObject f) {
        ChangeListener[] ll;
        GradleDependencyResult gradleDependencyResult = this;
        synchronized (gradleDependencyResult) {
            this.sourceMapping = null;
            if (this.sourceListeners == null || this.sourceListeners.isEmpty()) {
                return;
            }
            ll = this.sourceListeners.toArray(new ChangeListener[this.sourceListeners.size()]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    class DW
    implements DocumentListener {
        final Document doc;
        final FileObject file;

        public DW(FileObject file, Document doc) {
            this.file = file;
            this.doc = doc;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GradleDependencyResult.this.documentChanged(this.file);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GradleDependencyResult.this.documentChanged(this.file);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    static class Info {
        final GradleConfiguration config;
        final GradleDependency gradleDependency;

        public Info(GradleConfiguration config, GradleDependency gradleDependency) {
            this.config = config;
            this.gradleDependency = gradleDependency;
        }
    }
}

