/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.classpath.AbstractGradleClassPathImpl;
import org.netbeans.modules.gradle.java.execute.JavaRunUtils;
import org.openide.util.WeakListeners;

public final class BootClassPathImpl
extends AbstractGradleClassPathImpl
implements PropertyChangeListener {
    private static final String PROTOCOL_NBJRT = "nbjrt";
    JavaPlatformManager platformManager;
    final boolean modulesOnly;

    public BootClassPathImpl(Project proj) {
        this(proj, false);
    }

    public BootClassPathImpl(Project proj, boolean modulesOnly) {
        super(proj);
        this.modulesOnly = modulesOnly;
        this.platformManager = JavaPlatformManager.getDefault();
        this.platformManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platformManager));
        NbGradleProject.getPreferences((Project)this.project, (boolean)false).addPreferenceChangeListener(evt -> {
            if ("jdkPlatform".equals(evt.getKey())) {
                this.clearResourceCache();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.clearResourceCache();
    }

    @Override
    protected List<URL> createPath() {
        JavaPlatform platform = (JavaPlatform)JavaRunUtils.getActivePlatform(this.project).second();
        LinkedList<URL> ret = new LinkedList<URL>();
        if (platform != null) {
            for (ClassPath.Entry entry : platform.getBootstrapLibraries().entries()) {
                URL root = entry.getURL();
                if (this.modulesOnly && !PROTOCOL_NBJRT.equals(root.getProtocol())) continue;
                ret.add(root);
            }
        }
        return ret;
    }
}

