/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.classpath.AbstractGradleClassPathImpl;

public abstract class GradleGlobalClassPathImpl
extends AbstractGradleClassPathImpl {
    final boolean excludeTests;

    public GradleGlobalClassPathImpl(Project proj, boolean excludeTests) {
        super(proj);
        this.excludeTests = excludeTests;
    }

    @Override
    protected final List<URL> createPath() {
        GradleJavaProject jp = GradleJavaProject.get(this.project);
        List<URL> ret = Collections.emptyList();
        if (jp != null) {
            LinkedHashSet<URL> sources = new LinkedHashSet<URL>();
            for (GradleJavaSourceSet sourceSet : jp.getSourceSets().values()) {
                if (this.excludeTests && sourceSet.isTestSourceSet()) continue;
                GradleGlobalClassPathImpl.addAllFile(sources, this.selectFromSourceSet(sourceSet));
            }
            ret = new ArrayList<URL>(sources);
        }
        return ret;
    }

    protected abstract Set<File> selectFromSourceSet(GradleJavaSourceSet var1);

    public static class ProjectRuntimeClassPathImpl
    extends GradleGlobalClassPathImpl {
        public ProjectRuntimeClassPathImpl(Project proj, boolean excludeTests) {
            super(proj, excludeTests);
        }

        @Override
        protected Set<File> selectFromSourceSet(GradleJavaSourceSet sourceSet) {
            return sourceSet.getRuntimeClassPath();
        }
    }

    public static class ProjectCompileClassPathImpl
    extends GradleGlobalClassPathImpl {
        public ProjectCompileClassPathImpl(Project proj, boolean excludeTests) {
            super(proj, excludeTests);
        }

        @Override
        protected Set<File> selectFromSourceSet(GradleJavaSourceSet sourceSet) {
            return sourceSet.getCompileClassPath();
        }
    }

    public static class ProjectSourceClassPathImpl
    extends GradleGlobalClassPathImpl {
        public ProjectSourceClassPathImpl(Project proj, boolean excludeTests) {
            super(proj, excludeTests);
        }

        @Override
        protected Set<File> selectFromSourceSet(GradleJavaSourceSet sourceSet) {
            return (Set)sourceSet.getAllDirs();
        }
    }
}

