/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class GradleJavaTokenProvider
implements ReplaceTokenProvider {
    private static final String SELECTED_CLASS = "selectedClass";
    private static final String SELECTED_CLASS_NAME = "selectedClassName";
    private static final String SELECTED_PACKAGE = "selectedPackage";
    private static final String SELECTED_METHOD = "selectedMethod";
    private static final String AFFECTED_BUILD_TASK = "affectedBuildTasks";
    private static final Set<String> SUPPORTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("selectedClass", "selectedClassName", "selectedMethod", "selectedPackage", "affectedBuildTasks")));
    final Project project;

    public GradleJavaTokenProvider(Project project) {
        this.project = project;
    }

    public Set<String> getSupportedTokens() {
        return SUPPORTED;
    }

    public Map<String, String> createReplacements(String action, Lookup context) {
        HashMap<String, String> ret = new HashMap<String, String>();
        this.processSelectedPackageAndClass(ret, context);
        this.processSelectedMethod(ret, context);
        this.processSourceSets(ret, context);
        return ret;
    }

    private void processSelectedPackageAndClass(Map<String, String> map, Lookup context) {
        FileObject fo = RunUtils.extractFileObjectfromLookup((Lookup)context);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        String className = this.evaluateClassName(gjp, fo);
        if (className != null) {
            map.put(SELECTED_CLASS, className);
            int dot = className.lastIndexOf(46);
            if (dot != -1) {
                map.put(SELECTED_CLASS_NAME, className.substring(dot + 1));
                map.put(SELECTED_PACKAGE, className.substring(0, dot));
            } else {
                map.put(SELECTED_CLASS_NAME, className);
                map.put(SELECTED_PACKAGE, "");
            }
        }
    }

    private void processSelectedMethod(Map<String, String> map, Lookup context) {
        FileObject fo;
        SingleMethod method = (SingleMethod)context.lookup(SingleMethod.class);
        FileObject fileObject = fo = method != null ? method.getFile() : RunUtils.extractFileObjectfromLookup((Lookup)context);
        if (fo != null && fo.isData()) {
            GradleJavaProject gjp = GradleJavaProject.get(this.project);
            String className = this.evaluateClassName(gjp, fo);
            String selectedMethod = method != null ? className + '.' + method.getMethodName() : className;
            map.put(SELECTED_METHOD, selectedMethod);
        }
    }

    private void processSourceSets(Map<String, String> map, Lookup context) {
        FileObject[] fos = RunUtils.extractFileObjectsfromLookup((Lookup)context);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        if (fos.length > 0 && gjp != null) {
            HashSet<String> buildTasks = new HashSet<String>();
            for (FileObject fo : fos) {
                File f = FileUtil.toFile((FileObject)fo);
                GradleJavaSourceSet ss = gjp.containingSourceSet(f);
                if (ss == null) continue;
                Set<GradleJavaSourceSet.SourceType> types = ss.getSourceTypes(f);
                for (GradleJavaSourceSet.SourceType type : types) {
                    buildTasks.add(ss.getBuildTaskName(type));
                }
            }
            StringBuilder tasks = new StringBuilder();
            for (String task : buildTasks) {
                tasks.append(task).append(' ');
            }
            map.put(AFFECTED_BUILD_TASK, tasks.toString());
        }
    }

    private String evaluateClassName(GradleJavaProject gjp, FileObject fo) {
        File f;
        GradleJavaSourceSet sourceSet;
        String ret = null;
        if (gjp != null && fo != null && (sourceSet = gjp.containingSourceSet(f = FileUtil.toFile((FileObject)fo))) != null) {
            String relPath = sourceSet.relativePath(f);
            ret = (relPath.lastIndexOf(46) > 0 ? relPath.substring(0, relPath.lastIndexOf(46)) : relPath).replace('/', '.');
            if (fo.isFolder()) {
                ret = ret + '*';
            }
        }
        return ret;
    }
}

