/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.output;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.netbeans.modules.gradle.java.api.ProjectSourcesClassPathProvider;
import org.netbeans.modules.gradle.java.api.output.LocationOpener;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.windows.IOColors;

public class JavaCompilerProcessorFactory
implements OutputProcessorFactory {
    public Set<? extends OutputProcessor> createOutputProcessors(RunConfig cfg) {
        return new HashSet<StackTraceProcessor>(Arrays.asList(new StackTraceProcessor(cfg)));
    }

    private static Runnable openFileAt(final ClassPath classPath, final String fileName, final int line) {
        return new Runnable(){

            @Override
            public void run() {
                FileObject cpRoot;
                String baseName = fileName.substring(0, fileName.lastIndexOf(46));
                String resourceName = baseName + ".class";
                FileObject resource = classPath.findResource(resourceName);
                FileObject javaFo = null;
                if (resource != null && (cpRoot = classPath.findOwnerRoot(resource)) != null) {
                    FileObject[] rootz;
                    URL url = URLMapper.findURL((FileObject)cpRoot, (int)0);
                    SourceForBinaryQuery.Result res = SourceForBinaryQuery.findSourceRoots((URL)url);
                    for (FileObject root : rootz = res.getRoots()) {
                        javaFo = root.getFileObject(fileName);
                        if (javaFo == null) continue;
                        LocationOpener.openAtLine(javaFo, line, GradleSettings.getDefault().isReuseEditorOnStackTace());
                        break;
                    }
                }
                if (javaFo == null) {
                    StatusDisplayer.getDefault().setStatusText("Not found: " + fileName);
                }
            }
        };
    }

    private static class StackTraceProcessor
    implements OutputProcessor {
        private static final Pattern STACKTRACE_PATTERN = Pattern.compile("(.*)at (\\w[\\w\\.\\$<>]*)\\((\\w+)\\.java\\:([0-9]+)\\)(.*)");
        private static final IOColors.OutputType OUT_TYPE = IOColors.OutputType.ERROR;
        private final Project project;
        private final ClassPath classPath;

        private StackTraceProcessor(RunConfig cfg) {
            this.project = cfg.getProject();
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            ClassPath[] projectClassPath = cpProvider.getProjectClassPath("classpath/execute");
            ClassPath[] bootClassPath = cpProvider.getProjectClassPath("classpath/boot");
            this.classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createProxyClassPath((ClassPath[])projectClassPath), ClassPathSupport.createProxyClassPath((ClassPath[])bootClassPath)});
        }

        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = STACKTRACE_PATTERN.matcher(line);
            if (m.matches()) {
                String prefix = m.group(1);
                String method = m.group(2);
                String fileName = m.group(3);
                String lineNum = m.group(4);
                String postfix = m.group(5);
                int ppos = method.indexOf(fileName);
                if (ppos >= 0 && this.project != null) {
                    String pack = method.substring(0, ppos).replace('.', '/');
                    String javaName = pack + fileName + ".java";
                    int lineInt = Integer.parseInt(lineNum);
                    Runnable action = JavaCompilerProcessorFactory.openFileAt(this.classPath, javaName, lineInt);
                    out.print(prefix).print("at ", null, OUT_TYPE).print(method, null, OUT_TYPE).print("(", null, OUT_TYPE);
                    out.print(fileName + ".java:" + lineNum, action);
                    out.print(")" + postfix, null, OUT_TYPE);
                    return true;
                }
            }
            return false;
        }
    }
}

