/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class GradleJavaTokenProvider
implements ReplaceTokenProvider {
    private static final Set<String> SUPPORTED = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("selectedClass", "selectedMethod", "affectedBuildTasks")));
    final Project project;

    public GradleJavaTokenProvider(Project project) {
        this.project = project;
    }

    public Set<String> getSupportedTokens() {
        return SUPPORTED;
    }

    public Map<String, String> createReplacements(String action, Lookup context) {
        HashMap<String, String> ret = new HashMap<String, String>();
        this.processSelectedClass(ret, context);
        GradleJavaTokenProvider.processSelectedMethod(ret, context);
        this.processSourceSets(ret, context);
        return ret;
    }

    private void processSelectedClass(Map<String, String> map, Lookup context) {
        File f;
        GradleJavaSourceSet sourceSet;
        FileObject fo = RunUtils.extractFileObjectfromLookup((Lookup)context);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        if (gjp != null && fo != null && (sourceSet = gjp.containingSourceSet(f = FileUtil.toFile((FileObject)fo))) != null) {
            String relPath = sourceSet.relativePath(f);
            String className = relPath.substring(0, relPath.lastIndexOf(46)).replace('/', '.');
            map.put("selectedClass", className);
        }
    }

    private static void processSelectedMethod(Map<String, String> map, Lookup context) {
        String methodName;
        SingleMethod method = (SingleMethod)context.lookup(SingleMethod.class);
        FileObject fo = method != null ? method.getFile() : RunUtils.extractFileObjectfromLookup((Lookup)context);
        String string = methodName = method != null ? method.getMethodName() : null;
        if (fo != null) {
            String selectedMethod = GradleJavaTokenProvider.evaluateSingleMethod(fo, methodName);
            map.put("selectedMethod", selectedMethod);
        }
    }

    private void processSourceSets(Map<String, String> map, Lookup context) {
        FileObject[] fos = RunUtils.extractFileObjectsfromLookup((Lookup)context);
        GradleJavaProject gjp = GradleJavaProject.get(this.project);
        if (fos.length > 0 && gjp != null) {
            HashSet<String> buildTasks = new HashSet<String>();
            for (FileObject fo : fos) {
                File f = FileUtil.toFile((FileObject)fo);
                GradleJavaSourceSet ss = gjp.containingSourceSet(f);
                if (ss == null) continue;
                Set<GradleJavaSourceSet.SourceType> types = ss.getSourceTypes(f);
                for (GradleJavaSourceSet.SourceType type : types) {
                    buildTasks.add(ss.getBuildTaskName(type));
                }
            }
            StringBuilder tasks = new StringBuilder();
            for (String task : buildTasks) {
                tasks.append(task).append(' ');
            }
            map.put("affectedBuildTasks", tasks.toString());
        }
    }

    private static String evaluateSingleMethod(final FileObject fo, final String method) {
        final Object[] ret = new Object[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Trees trees = compilationController.getTrees();
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                        for (Tree tree : typeDecls) {
                            Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                            if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                            TypeElement type = (TypeElement)element;
                            StringBuilder sb = new StringBuilder(type.getQualifiedName());
                            if (method != null) {
                                sb.append('.').append(method);
                            }
                            ret[0] = sb.toString();
                            break;
                        }
                    }
                }, true);
                return ret[0].toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

