/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.io.Reader;
import java.nio.charset.Charset;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.ParametrizedRunnable;
import org.netbeans.api.extexecution.base.input.InputProcessor;

public final class BaseExecutionDescriptor {
    private final Charset charset;
    private final Runnable preExecution;
    private final ParametrizedRunnable<Integer> postExecution;
    private final InputProcessorFactory outProcessorFactory;
    private final InputProcessorFactory errProcessorFactory;
    private final ReaderFactory inReaderFactory;

    public BaseExecutionDescriptor() {
        this(null, null, null, null, null, null);
    }

    private BaseExecutionDescriptor(Charset charset, Runnable preExecution, ParametrizedRunnable<Integer> postExecution, InputProcessorFactory outProcessorFactory, InputProcessorFactory errProcessorFactory, ReaderFactory inReaderFactory) {
        this.charset = charset;
        this.preExecution = preExecution;
        this.postExecution = postExecution;
        this.outProcessorFactory = outProcessorFactory;
        this.errProcessorFactory = errProcessorFactory;
        this.inReaderFactory = inReaderFactory;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor charset(@NullAllowed Charset charset) {
        return new BaseExecutionDescriptor(charset, this.preExecution, this.postExecution, this.outProcessorFactory, this.errProcessorFactory, this.inReaderFactory);
    }

    Charset getCharset() {
        return this.charset;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor preExecution(@NullAllowed Runnable preExecution) {
        return new BaseExecutionDescriptor(this.charset, preExecution, this.postExecution, this.outProcessorFactory, this.errProcessorFactory, this.inReaderFactory);
    }

    Runnable getPreExecution() {
        return this.preExecution;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor postExecution(@NullAllowed ParametrizedRunnable<Integer> postExecution) {
        return new BaseExecutionDescriptor(this.charset, this.preExecution, postExecution, this.outProcessorFactory, this.errProcessorFactory, this.inReaderFactory);
    }

    ParametrizedRunnable<Integer> getPostExecution() {
        return this.postExecution;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor outProcessorFactory(@NullAllowed InputProcessorFactory outProcessorFactory) {
        return new BaseExecutionDescriptor(this.charset, this.preExecution, this.postExecution, outProcessorFactory, this.errProcessorFactory, this.inReaderFactory);
    }

    InputProcessorFactory getOutProcessorFactory() {
        return this.outProcessorFactory;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor errProcessorFactory(@NullAllowed InputProcessorFactory errProcessorFactory) {
        return new BaseExecutionDescriptor(this.charset, this.preExecution, this.postExecution, this.outProcessorFactory, errProcessorFactory, this.inReaderFactory);
    }

    InputProcessorFactory getErrProcessorFactory() {
        return this.errProcessorFactory;
    }

    @NonNull
    @CheckReturnValue
    public BaseExecutionDescriptor inReaderFactory(@NullAllowed ReaderFactory inReaderFactory) {
        return new BaseExecutionDescriptor(this.charset, this.preExecution, this.postExecution, this.outProcessorFactory, this.errProcessorFactory, inReaderFactory);
    }

    ReaderFactory getInReaderFactory() {
        return this.inReaderFactory;
    }

    public static interface ReaderFactory {
        @CheckForNull
        public Reader newReader();
    }

    public static interface InputProcessorFactory {
        @CheckForNull
        public InputProcessor newInputProcessor();
    }
}

