/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;

public final class PersistentValues {
    private final VirtualMachine vm;
    private final List<ObjectReference> references = new ArrayList<ObjectReference>(5);

    public PersistentValues(VirtualMachine vm) {
        this.vm = vm;
    }

    public StringReference mirrorOf(String string) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        StringReference stringMirror = null;
        while (stringMirror == null) {
            stringMirror = VirtualMachineWrapper.mirrorOf((VirtualMachine)this.vm, (String)string);
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)stringMirror);
            }
            catch (ObjectCollectedExceptionWrapper ce) {
                stringMirror = null;
            }
        }
        this.references.add(stringMirror);
        return stringMirror;
    }

    public StringReference mirrorOf0(String string) {
        try {
            return this.mirrorOf(string);
        }
        catch (InternalExceptionWrapper | UnsupportedOperationExceptionWrapper | VMDisconnectedExceptionWrapper e) {
            return null;
        }
    }

    public <T extends ObjectReference> T valueOf(ValueSupplier<T> valueSupplier) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        ObjectReference value = null;
        while (value == null) {
            value = (ObjectReference)valueSupplier.get();
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)value);
            }
            catch (ObjectCollectedExceptionWrapper ce) {
                value = null;
            }
        }
        this.references.add(value);
        return (T)value;
    }

    public <T extends ObjectReference> T invokeOf(InvokeSupplier<T> valueSupplier) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, InvocationException, ObjectCollectedExceptionWrapper {
        ObjectReference value = null;
        while (value == null) {
            value = (ObjectReference)valueSupplier.get();
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)value);
            }
            catch (ObjectCollectedExceptionWrapper ce) {
                value = null;
            }
        }
        this.references.add(value);
        return (T)value;
    }

    public void collect() {
        for (ObjectReference reference : this.references) {
            try {
                ObjectReferenceWrapper.enableCollection((ObjectReference)reference);
            }
            catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | UnsupportedOperationExceptionWrapper throwable) {
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                break;
            }
        }
        this.references.clear();
    }

    @FunctionalInterface
    public static interface InvokeSupplier<T> {
        public T get() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, InvocationException, ObjectCollectedExceptionWrapper;
    }

    @FunctionalInterface
    public static interface ValueSupplier<T> {
        public T get() throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, UnsupportedOperationExceptionWrapper;
    }
}

