/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl;

import com.sun.jdi.ObjectReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.util.Pair;

final class TruffleBreakpointsRegistry {
    private static final TruffleBreakpointsRegistry DEFAULT = new TruffleBreakpointsRegistry();
    private final Map<JPDADebugger, Map<ObjectReference, JSLineBreakpoint>> breakpoints = new ConcurrentHashMap<JPDADebugger, Map<ObjectReference, JSLineBreakpoint>>();

    private TruffleBreakpointsRegistry() {
    }

    static TruffleBreakpointsRegistry getDefault() {
        return DEFAULT;
    }

    void add(JPDADebugger debugger, JSLineBreakpoint breakpoint, ObjectReference truffleBreakpoint) {
        Map bps = this.breakpoints.get(debugger);
        if (bps == null) {
            bps = this.breakpoints.computeIfAbsent(debugger, key -> new ConcurrentHashMap());
        }
        bps.put((ObjectReference)truffleBreakpoint, (JSLineBreakpoint)breakpoint);
    }

    void remove(JPDADebugger debugger, ObjectReference truffleBreakpoint) {
        Map<ObjectReference, JSLineBreakpoint> bps = this.breakpoints.get(debugger);
        if (bps != null) {
            bps.remove(truffleBreakpoint);
        }
    }

    void dispose(JPDADebugger debugger) {
        this.breakpoints.remove(debugger);
    }

    Pair<JPDADebugger, JSLineBreakpoint> get(ObjectReference truffleBreakpoint) {
        for (Map.Entry<JPDADebugger, Map<ObjectReference, JSLineBreakpoint>> bpsEntry : this.breakpoints.entrySet()) {
            JSLineBreakpoint bp = bpsEntry.getValue().get(truffleBreakpoint);
            if (bp == null) continue;
            return Pair.of((Object)bpsEntry.getKey(), (Object)bp);
        }
        return null;
    }
}

