/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DatabaseConnectionConvertor
implements Environment.Provider,
InstanceCookie.Of {
    public static final String CONNECTIONS_PATH = "Databases/Connections";
    public static final Logger LOGGER = Logger.getLogger(DatabaseConnectionConvertor.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(DatabaseConnectionConvertor.class);
    private static final int DELAY = 2000;
    private static final WeakHashMap<DatabaseConnection, DataObject> newConn2DO = new WeakHashMap();
    private static final Map<FileObject, DatabaseConnection> newFile2Conn = new ConcurrentHashMap<FileObject, DatabaseConnection>();
    private final Reference<XMLDataObject> holder;
    private Lookup lookup = null;
    private Reference<DatabaseConnection> refConnection = new WeakReference<Object>(null);
    private PCL listener;

    private static DatabaseConnectionConvertor createProvider() {
        return new DatabaseConnectionConvertor();
    }

    private DatabaseConnectionConvertor() {
        this.holder = new WeakReference<Object>(null);
    }

    private DatabaseConnectionConvertor(XMLDataObject object) {
        this.holder = new WeakReference<XMLDataObject>(object);
        InstanceContent cookies = new InstanceContent();
        cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)cookies);
    }

    private DatabaseConnectionConvertor(XMLDataObject object, DatabaseConnection existingInstance) {
        this(object);
        this.refConnection = new WeakReference<DatabaseConnection>(existingInstance);
        this.attachListener();
    }

    public Lookup getEnvironment(DataObject obj) {
        DatabaseConnection existingInstance = newFile2Conn.remove(obj.getPrimaryFile());
        if (existingInstance != null) {
            return new DatabaseConnectionConvertor((XMLDataObject)obj, existingInstance).getLookup();
        }
        return new DatabaseConnectionConvertor((XMLDataObject)obj).getLookup();
    }

    public String instanceName() {
        XMLDataObject obj = this.getHolder();
        return obj == null ? "" : obj.getName();
    }

    public Class<DatabaseConnection> instanceClass() {
        return DatabaseConnection.class;
    }

    public boolean instanceOf(Class<?> type) {
        return type.isAssignableFrom(DatabaseConnection.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException, ClassNotFoundException {
        DatabaseConnectionConvertor databaseConnectionConvertor = this;
        synchronized (databaseConnectionConvertor) {
            DatabaseConnection o = this.refConnection.get();
            if (o != null) {
                return o;
            }
            XMLDataObject obj = this.getHolder();
            if (obj == null) {
                return null;
            }
            FileObject connectionFO = obj.getPrimaryFile();
            Handler handler = new Handler(connectionFO.getNameExt());
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(obj.getPrimaryFile().getInputStream());
                is.setSystemId(connectionFO.toURL().toExternalForm());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception x = ex.getException();
                LOGGER.log(Level.FINE, "Cannot read " + obj + ". Cause: " + ex.getLocalizedMessage(), ex);
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                throw new IOException(ex.getMessage());
            }
            DatabaseConnection inst = DatabaseConnectionConvertor.createDatabaseConnection(handler);
            this.refConnection = new WeakReference<DatabaseConnection>(inst);
            this.attachListener();
            return inst;
        }
    }

    private XMLDataObject getHolder() {
        return this.holder.get();
    }

    private void attachListener() {
        this.listener = new PCL();
        DatabaseConnection dbconn = this.refConnection.get();
        dbconn.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)dbconn));
    }

    private static DatabaseConnection createDatabaseConnection(Handler handler) {
        DatabaseConnection dbconn = new DatabaseConnection(handler.driverClass, handler.driverName, handler.connectionUrl, handler.schema, handler.user, handler.connectionProperties);
        dbconn.setConnectionFileName(handler.connectionFileName);
        if (handler.displayName != null) {
            dbconn.setDisplayName(handler.displayName);
        }
        for (String importantSchema : handler.importantSchemas) {
            dbconn.addImportantSchema(importantSchema);
        }
        for (String importantDatabase : handler.importantCatalogs) {
            dbconn.addImportantCatalog(importantDatabase);
        }
        dbconn.setSeparateSystemTables(handler.separateSystemTables);
        if (handler.useScrollableCursors != null) {
            dbconn.setUseScrollableCursors(handler.useScrollableCursors);
        }
        LOGGER.log(Level.FINE, "Created DatabaseConnection[{0}] from file: {1}", new Object[]{dbconn, handler.connectionFileName});
        return dbconn;
    }

    public static DataObject create(DatabaseConnection dbconn) throws IOException {
        FileObject fo = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CONNECTIONS_PATH);
        DataFolder df = DataFolder.findFolder((FileObject)fo);
        AtomicWriter writer = new AtomicWriter(dbconn, df, DatabaseConnectionConvertor.convertToFileName(dbconn.getName()));
        df.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)writer);
        return writer.holder;
    }

    private static String convertToFileName(String databaseURL) {
        return databaseURL.substring(0, Math.min(32, databaseURL.length())).replaceAll("[^\\p{Alnum}]", "_");
    }

    public static void remove(DatabaseConnection dbconn) throws IOException {
        String name = dbconn.getName();
        FileObject fo = FileUtil.getConfigFile((String)CONNECTIONS_PATH);
        if (fo == null) {
            return;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)fo);
        DataObject[] objects = folder.getChildren();
        for (int i = 0; i < objects.length; ++i) {
            DatabaseConnection connection;
            Object obj;
            InstanceCookie ic = (InstanceCookie)objects[i].getCookie(InstanceCookie.class);
            if (ic == null) continue;
            try {
                obj = ic.instanceCreate();
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!(obj instanceof DatabaseConnection) || !(connection = (DatabaseConnection)obj).getName().equals(name)) continue;
            objects[i].delete();
            break;
        }
    }

    Lookup getLookup() {
        return this.lookup;
    }

    static byte[] decodeBase64(String value) {
        return Base64.getDecoder().decode(value);
    }

    static String decodePassword(byte[] bytes) throws CharacterCodingException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        ByteBuffer input = ByteBuffer.wrap(bytes);
        int outputLength = (int)((double)bytes.length * (double)decoder.maxCharsPerByte());
        if (outputLength == 0) {
            return "";
        }
        char[] chars = new char[outputLength];
        CharBuffer output = CharBuffer.wrap(chars);
        CoderResult result = decoder.decode(input, output, true);
        if (!result.isError() && !result.isOverflow()) {
            result = decoder.flush(output);
        }
        if (result.isError() || result.isOverflow()) {
            throw new CharacterCodingException();
        }
        return new String(chars, 0, output.position());
    }

    private static final class Handler
    extends DefaultHandler {
        private static final String ELEMENT_DRIVER_CLASS = "driver-class";
        private static final String ELEMENT_DRIVER_NAME = "driver-name";
        private static final String ELEMENT_DATABASE_URL = "database-url";
        private static final String ELEMENT_SCHEMA = "schema";
        private static final String ELEMENT_USER = "user";
        private static final String ELEMENT_PASSWORD = "password";
        private static final String ELEMENT_DISPLAY_NAME = "display-name";
        private static final String ELEMENT_IMPORTANT_SCHEMA = "important-schema";
        private static final String ELEMENT_IMPORTANT_CATALOG = "important-catalog";
        private static final String ELEMENT_CONNECTION_PROPERTY = "connection-property";
        private static final String ELEMENT_SEPARATE_SYS_TABLES = "separate-system-tables";
        private static final String ELEMENT_USE_SCROLLABLE_CURSORS = "use-scrollable-cursors";
        private static final String ELEMENT_CONNECTION_PROPERTY_NAME = "name";
        private static final String ELEMENT_CONNECTION_PROPERTY_VALUE = "value";
        private static final String ATTR_PROPERTY_VALUE = "value";
        final String connectionFileName;
        private boolean readingProperty = false;
        private String propertyName;
        private String propertyValue;
        private final StringBuilder buffer = new StringBuilder();
        String driverClass;
        String driverName;
        String connectionUrl;
        String schema;
        String user;
        String displayName;
        Properties connectionProperties;
        boolean separateSystemTables = false;
        Boolean useScrollableCursors = null;
        List<String> importantSchemas = new ArrayList<String>();
        List<String> importantCatalogs = new ArrayList<String>();

        public Handler(String connectionFileName) {
            this.connectionFileName = connectionFileName;
            this.connectionProperties = new Properties();
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String value = attrs.getValue("value");
            if (ELEMENT_DRIVER_CLASS.equals(qName)) {
                this.driverClass = value;
            } else if (ELEMENT_DRIVER_NAME.equals(qName)) {
                this.driverName = value;
            } else if (ELEMENT_DATABASE_URL.equals(qName)) {
                this.connectionUrl = value;
            } else if (ELEMENT_SCHEMA.equals(qName)) {
                this.schema = value;
            } else if (ELEMENT_USER.equals(qName)) {
                this.user = value;
            } else if (ELEMENT_DISPLAY_NAME.equals(qName)) {
                this.displayName = value;
            } else if (ELEMENT_CONNECTION_PROPERTY.equals(qName)) {
                this.readingProperty = true;
                this.propertyName = "";
                this.propertyValue = "";
            } else if (this.readingProperty && ELEMENT_CONNECTION_PROPERTY_NAME.equals(qName)) {
                this.buffer.setLength(0);
            } else if (this.readingProperty && "value".equals(qName)) {
                this.buffer.setLength(0);
            } else if (ELEMENT_PASSWORD.equals(qName)) {
                byte[] bytes = null;
                try {
                    bytes = DatabaseConnectionConvertor.decodeBase64(value);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, "Illegal Base 64 string in password for connection " + this.connectionFileName, e);
                }
                if (bytes != null) {
                    try {
                        LOGGER.log(Level.FINE, "Reading old settings from {0}", this.connectionFileName);
                        DatabaseConnection.storePassword(this.connectionFileName, DatabaseConnectionConvertor.decodePassword(bytes).toCharArray());
                    }
                    catch (CharacterCodingException e) {
                        LOGGER.log(Level.WARNING, "Illegal UTF-8 bytes in password for connection " + this.connectionFileName, e);
                    }
                }
            } else if (ELEMENT_IMPORTANT_SCHEMA.equals(qName)) {
                this.importantSchemas.add(value);
            } else if (ELEMENT_IMPORTANT_CATALOG.equals(qName)) {
                this.importantCatalogs.add(value);
            } else if (ELEMENT_SEPARATE_SYS_TABLES.equals(qName)) {
                this.separateSystemTables = Boolean.parseBoolean(value);
            } else if (ELEMENT_USE_SCROLLABLE_CURSORS.equals(qName)) {
                this.useScrollableCursors = Boolean.parseBoolean(value);
            }
        }

        @Override
        public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
            if (this.readingProperty) {
                this.buffer.append(chars, start, length);
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.readingProperty) {
                this.buffer.append(chars, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.readingProperty && ELEMENT_CONNECTION_PROPERTY.equals(qName)) {
                this.connectionProperties.put(this.propertyName, this.propertyValue);
                this.readingProperty = false;
                this.propertyName = "";
                this.propertyValue = "";
                this.buffer.setLength(0);
            } else if (this.readingProperty && ELEMENT_CONNECTION_PROPERTY_NAME.equals(qName)) {
                this.propertyName = this.buffer.toString();
            } else if (this.readingProperty && "value".equals(qName)) {
                this.propertyValue = this.buffer.toString();
            }
        }
    }

    private final class PCL
    implements PropertyChangeListener,
    Runnable {
        LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
        RequestProcessor.Task saveTask = null;

        private PCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName())) {
                return;
            }
            PCL pCL = this;
            synchronized (pCL) {
                if (this.saveTask == null) {
                    this.saveTask = RP.create((Runnable)this);
                }
                this.keepAlive.add(evt);
            }
            this.saveTask.schedule(2000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PropertyChangeEvent e;
            PCL pCL = this;
            synchronized (pCL) {
                e = this.keepAlive.removeFirst();
            }
            DatabaseConnection dbconn = (DatabaseConnection)e.getSource();
            XMLDataObject obj = DatabaseConnectionConvertor.this.getHolder();
            if (obj == null) {
                return;
            }
            try {
                obj.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new AtomicWriter(dbconn, (MultiDataObject)obj));
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
    }

    private static final class AtomicWriter
    implements FileSystem.AtomicAction {
        DatabaseConnection instance;
        MultiDataObject holder;
        String fileName;
        DataFolder parent;

        AtomicWriter(DatabaseConnection instance, MultiDataObject holder) {
            this.instance = instance;
            this.holder = holder;
            this.fileName = holder.getPrimaryFile().getNameExt();
        }

        AtomicWriter(DatabaseConnection instance, DataFolder parent, String fileName) {
            this.instance = instance;
            this.fileName = fileName;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.parent.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.fileName, (String)"xml");
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try (OutputStream ostm = data.getOutputStream(lck);
                 PrintWriter writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));){
                this.write(writer, data.getNameExt());
                writer.flush();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                newFile2Conn.put(data, this.instance);
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
                this.holder.getCookie(InstanceCookie.class);
                newConn2DO.put(this.instance, (DataObject)this.holder);
            }
        }

        void write(PrintWriter pw, String name) throws IOException {
            pw.println("<?xml version='1.0'?>");
            pw.println("<!DOCTYPE connection PUBLIC '-//NetBeans//DTD Database Connection 1.2//EN' 'http://www.netbeans.org/dtds/connection-1_2.dtd'>");
            pw.println("<connection>");
            pw.println("  <driver-class value='" + XMLUtil.toAttributeValue((String)this.instance.getDriver()) + "'/>");
            pw.println("  <driver-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDriverName()) + "'/>");
            pw.println("  <database-url value='" + XMLUtil.toAttributeValue((String)this.instance.getDatabase()) + "'/>");
            if (this.instance.getSchema() != null) {
                pw.println("  <schema value='" + XMLUtil.toAttributeValue((String)this.instance.getSchema()) + "'/>");
            }
            if (this.instance.getUser() != null) {
                pw.println("  <user value='" + XMLUtil.toAttributeValue((String)this.instance.getUser()) + "'/>");
            }
            if (!this.instance.getName().equals(this.instance.getDisplayName())) {
                pw.println("  <display-name value='" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "'/>");
            }
            for (String importantSchema : this.instance.getImportantSchemas()) {
                pw.println("  <important-schema value='" + XMLUtil.toAttributeValue((String)importantSchema) + "'/>");
            }
            for (String importantDatabase : this.instance.getImportantCatalogs()) {
                pw.println("  <important-catalog value='" + XMLUtil.toAttributeValue((String)importantDatabase) + "'/>");
            }
            if (this.instance.rememberPassword()) {
                char[] password = this.instance.getPassword() == null ? new char[]{} : this.instance.getPassword().toCharArray();
                DatabaseConnection.storePassword(name, password);
            } else {
                DatabaseConnection.deletePassword(name);
            }
            if (this.instance.getConnectionProperties() != null) {
                Properties p = this.instance.getConnectionProperties();
                for (String key : p.stringPropertyNames()) {
                    pw.println("  <connection-property>");
                    pw.print("    <name>");
                    pw.print(XMLUtil.toElementContent((String)key));
                    pw.println("</name>");
                    pw.print("    <value>");
                    pw.print(XMLUtil.toElementContent((String)p.getProperty(key)));
                    pw.println("</value>");
                    pw.println("  </connection-property>");
                }
            }
            if (this.instance.isSeparateSystemTables()) {
                pw.println("  <separate-system-tables value='true'/>");
            }
            pw.println("  <use-scrollable-cursors value='" + this.instance.isUseScrollableCursors() + "'/>");
            pw.println("</connection>");
        }
    }
}

