/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.ProgressPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class DbUtilities {
    private DbUtilities() {
    }

    public static String formatError(String message, String exception) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        if (exception != null) {
            int index;
            String format = NbBundle.getMessage(DbUtilities.class, (String)"ERR_UnableTo_Detail");
            StringBuilder formattedException = new StringBuilder(exception.trim());
            if (formattedException.length() > 0) {
                formattedException.setCharAt(0, Character.toUpperCase(formattedException.charAt(0)));
            }
            for (index = formattedException.length(); index > 0 && ".!?".indexOf(formattedException.charAt(index - 1)) >= 0; --index) {
            }
            formattedException.delete(index, formattedException.length());
            formattedException.append('.');
            return MessageFormat.format(format, message, formattedException);
        }
        String format = NbBundle.getMessage(DbUtilities.class, (String)"ERR_UnableTo_NoDetail");
        return MessageFormat.format(format, message);
    }

    public static void reportError(String message, String exception) {
        String error = DbUtilities.formatError(message, exception);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)error, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doWithProgress(String message, final Callable<? extends T> run) throws InvocationTargetException {
        final ProgressPanel panel = new ProgressPanel();
        panel.setCancelVisible(false);
        panel.setText(message);
        ProgressHandle handle = ProgressHandleFactory.createHandle(null);
        JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        handle.start();
        final ArrayList result = new ArrayList(1);
        final ArrayList exception = new ArrayList(1);
        try {
            RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            result.add(run.call());
                            exception.add(null);
                        }
                        catch (Exception e) {
                            result.add(null);
                            exception.add(e);
                        }
                        finally {
                            SwingUtilities.invokeLater(this);
                        }
                    } else {
                        panel.close();
                    }
                }
            });
            panel.open(progress);
            task.waitFinished();
        }
        finally {
            handle.finish();
        }
        Exception inner = (Exception)exception.get(0);
        if (inner != null) {
            throw new InvocationTargetException(inner, inner.getMessage());
        }
        return (T)result.get(0);
    }
}

