/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Lookup;

public class ConnectionNodeProvider
extends NodeProvider {
    private final PropertyChangeListener PCL = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equals("displayName")) {
                if (pce.getSource() instanceof DatabaseConnection) {
                    ConnectionNodeProvider.this.initialize((DatabaseConnection)pce.getSource());
                } else {
                    ConnectionNodeProvider.this.initialize();
                }
            }
        }
    };
    private final ConnectionList connectionList = (ConnectionList)this.getLookup().lookup(ConnectionList.class);
    private static final Comparator<Node> connectionNodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareToIgnoreCase(model2.getDisplayName());
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private void scheduleNodeSelectionAfterUpdate(final DatabaseConnection connToSelect) {
        NodeAdapter nl = new NodeAdapter(){

            public void childrenAdded(NodeMemberEvent ev) {
                this.select();
            }

            public void childrenReordered(NodeReorderEvent ev) {
                this.select();
            }

            private void select() {
                if (SwingUtilities.isEventDispatchThread()) {
                    connToSelect.selectInExplorer(false);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            connToSelect.selectInExplorer(false);
                        }
                    });
                }
                RootNode.instance().removeNodeListener((NodeListener)this);
            }
        };
        RootNode.instance().addNodeListener((NodeListener)nl);
    }

    private ConnectionNodeProvider(Lookup lookup) {
        super(lookup, connectionNodeComparator);
    }

    private void setup() {
        this.connectionList.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionsChanged() {
                ConnectionNodeProvider.this.initialize();
            }
        });
    }

    @Override
    protected synchronized void initialize() {
        this.initialize(null);
    }

    protected synchronized void initialize(DatabaseConnection selectedConn) {
        DatabaseConnection connToSelect;
        DatabaseConnection[] connections;
        ArrayList<Node> newList = new ArrayList<Node>();
        DatabaseConnection newConnection = null;
        for (DatabaseConnection connection : connections = this.connectionList.getConnections()) {
            connection.removePropertyChangeListener(this.PCL);
            connection.addPropertyChangeListener(this.PCL);
            Collection<Node> matches = this.getNodes(connection);
            if (matches.size() > 0) {
                newList.addAll(matches);
                continue;
            }
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(connection);
            newConnection = connection;
            newList.add((Node)ConnectionNode.create(lookup, this));
        }
        DatabaseConnection databaseConnection = connToSelect = newConnection != null ? newConnection : selectedConn;
        if (connToSelect != null) {
            this.scheduleNodeSelectionAfterUpdate(connToSelect);
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ConnectionNodeProvider createInstance(Lookup lookup) {
                ConnectionNodeProvider provider = new ConnectionNodeProvider(lookup);
                provider.setup();
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

