/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.spi.ForeignKeyImplementation;

public class JDBCForeignKey
extends ForeignKeyImplementation {
    private final Table parent;
    private final String name;
    private final Map<String, ForeignKeyColumn> columns = new LinkedHashMap<String, ForeignKeyColumn>();
    private final String internalName;
    private static AtomicLong fkeyCounter = new AtomicLong(0L);

    public JDBCForeignKey(Table parent, String name) {
        this.parent = parent;
        this.name = name;
        this.internalName = parent.getName() + "_FKEY_" + fkeyCounter.incrementAndGet();
    }

    public void addColumn(ForeignKeyColumn col) {
        this.columns.put(col.getName(), col);
    }

    @Override
    public final Table getParent() {
        return this.parent;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return "JDBCForeignKey[name='" + this.name + "']";
    }

    @Override
    public Collection<ForeignKeyColumn> getColumns() {
        return this.columns.values();
    }

    @Override
    public ForeignKeyColumn getColumn(String name) {
        return this.columns.get(name);
    }

    @Override
    public String getInternalName() {
        String result = this.getName();
        return result != null ? result : this.internalName;
    }
}

