/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.util.Collection;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.openide.filesystems.FileObject;

public final class GsfParserFactory
extends ParserFactory {
    private final String mimeType;

    public static ParserFactory create(FileObject f) {
        String mimeType = f.getParent().getPath().substring("Editors/".length());
        return new GsfParserFactory(mimeType);
    }

    public Parser createParser(Collection<Snapshot> snapshots) {
        for (Snapshot s : snapshots) {
            MimePath p = MimePath.get((String)s.getMimeType());
            String inhType = p.getInheritedType();
            if (p.getMimeType(0).equals(this.mimeType) || this.mimeType.equals(inhType)) continue;
            return null;
        }
        Language l = LanguageRegistry.getInstance().getLanguageByMimeType(this.mimeType);
        assert (l != null) : "No CSL language registered for " + this.mimeType;
        return l == null ? null : l.getParser(snapshots);
    }

    private GsfParserFactory(String mimeType) {
        this.mimeType = mimeType;
    }
}

