/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.MoveTreeCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class RenameCommand
extends MoveTreeCommand {
    final File source;
    final File target;
    final boolean after;

    public RenameCommand(Repository repository, GitClassFactory gitFactory, File source, File target, boolean after, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, source, target, after, false, monitor, listener);
        this.source = source;
        this.target = target;
        this.after = after;
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            if (this.source.equals(this.getRepository().getWorkTree())) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_CannotMoveWT"), this.source.getAbsolutePath()));
            }
            if (!this.source.exists() && !this.after) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_SourceDoesNotExist"), this.source.getAbsolutePath()));
            }
            if (this.target.exists()) {
                if (!this.after) {
                    throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_TargetExists"), this.target.getAbsolutePath()));
                }
            } else if (this.after) {
                throw new GitException(MessageFormat.format(Utils.getBundle(RenameCommand.class).getString("MSG_Exception_TargetDoesNotExist"), this.target.getAbsolutePath()));
            }
        }
        return retval;
    }

    @Override
    protected String getCommandDescription() {
        return "git mv " + this.source + " " + this.target;
    }
}

