/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.SubmoduleInitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitSubmoduleStatus;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.SubmoduleStatusCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class SubmoduleInitializeCommand
extends GitCommand {
    private final File[] roots;
    private final SubmoduleStatusCommand statusCmd;

    public SubmoduleInitializeCommand(Repository repository, GitClassFactory classFactory, File[] roots, ProgressMonitor monitor) {
        super(repository, classFactory, monitor);
        this.roots = roots;
        this.statusCmd = new SubmoduleStatusCommand(repository, this.getClassFactory(), roots, new DelegatingGitProgressMonitor(monitor));
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        File workTree = repository.getWorkTree();
        SubmoduleInitCommand cmd = new Git(repository).submoduleInit();
        for (String path : Utils.getRelativePaths(workTree, this.roots)) {
            cmd.addPath(path);
        }
        try {
            cmd.call();
            this.statusCmd.run();
        }
        catch (GitAPIException | JGitInternalException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git submodule initialize");
        for (File root : this.roots) {
            sb.append(" ").append(root.getAbsolutePath());
        }
        return sb.toString();
    }

    public Map<File, GitSubmoduleStatus> getStatuses() {
        return this.statusCmd.getStatuses();
    }
}

