/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CleanCommand
extends GitCommand {
    private final File[] roots;
    private final ProgressMonitor monitor;
    private final FileListener listener;

    public CleanCommand(Repository repository, GitClassFactory gitFactory, File[] roots, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.listener = listener;
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git clean -d");
        for (File root : this.roots) {
            sb.append(" ").append(root);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            DirCache cache = null;
            try {
                cache = repository.lockDirCache();
                TreeWalk treeWalk = new TreeWalk(repository);
                Collection<PathFilter> pathFilters = Utils.getPathFilters(repository.getWorkTree(), this.roots);
                if (!pathFilters.isEmpty()) {
                    treeWalk.setFilter(PathFilterGroup.create(pathFilters));
                }
                treeWalk.setRecursive(false);
                treeWalk.setPostOrderTraversal(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    WorkingTreeIterator f = (WorkingTreeIterator)treeWalk.getTree(0, WorkingTreeIterator.class);
                    if (f == null) continue;
                    if (!treeWalk.isPostChildren()) {
                        if (treeWalk.isSubtree()) {
                            treeWalk.enterSubtree();
                            continue;
                        }
                        this.deleteIfUnversioned(cache, path, f, repository, treeWalk);
                        continue;
                    }
                    this.deleteIfUnversioned(cache, path, f, repository, treeWalk);
                }
            }
            finally {
                if (cache != null) {
                    cache.unlock();
                }
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    private void deleteIfUnversioned(DirCache cache, String path, WorkingTreeIterator f, Repository repository, TreeWalk treeWalk) throws IOException, NoWorkTreeException {
        if (cache.getEntry(path) == null && !f.isEntryIgnored() && !Utils.isFromNested(f.getEntryFileMode().getBits())) {
            String[] s;
            File file = new File(repository.getWorkTree().getAbsolutePath() + File.separator + path);
            if (file.isDirectory() && (s = file.list()) != null && s.length > 0) {
                return;
            }
            file.delete();
            this.listener.notifyFile(file, treeWalk.getPathString());
        }
    }
}

