/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.netbeans.api.visual.widget.Scene;

public final class SatelliteComponent
extends JComponent
implements MouseListener,
MouseMotionListener,
Scene.SceneListener,
ComponentListener {
    private Scene scene;

    public SatelliteComponent(Scene scene) {
        this.scene = scene;
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(128, 128));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.scene.addSceneListener(this);
        JComponent viewComponent = this.scene.getView();
        if (viewComponent == null) {
            viewComponent = this.scene.createView();
        }
        viewComponent.addComponentListener(this);
        this.repaint();
    }

    @Override
    public void removeNotify() {
        this.scene.getView().removeComponentListener(this);
        this.scene.removeSceneListener(this);
        super.removeNotify();
    }

    @Override
    public void paint(Graphics g) {
        Rectangle viewRectangle;
        Graphics2D gr = (Graphics2D)g;
        super.paint(g);
        Rectangle bounds = this.scene.getBounds();
        Dimension size = this.getSize();
        double sx = bounds.width > 0 ? (double)size.width / (double)bounds.width : 0.0;
        double sy = bounds.width > 0 ? (double)size.height / (double)bounds.height : 0.0;
        double scale = Math.min(sx, sy);
        int vw = (int)(scale * (double)bounds.width);
        int vh = (int)(scale * (double)bounds.height);
        int vx = (size.width - vw) / 2;
        int vy = (size.height - vh) / 2;
        AffineTransform previousTransform = gr.getTransform();
        gr.translate(vx, vy);
        gr.scale(scale, scale);
        this.scene.paint(gr);
        gr.setTransform(previousTransform);
        JComponent component = this.scene.getView();
        double zoomFactor = this.scene.getZoomFactor();
        Rectangle rectangle = viewRectangle = component != null ? component.getVisibleRect() : null;
        if (viewRectangle != null) {
            Rectangle window = new Rectangle((int)((double)viewRectangle.x * scale / zoomFactor), (int)((double)viewRectangle.y * scale / zoomFactor), (int)((double)viewRectangle.width * scale / zoomFactor), (int)((double)viewRectangle.height * scale / zoomFactor));
            window.translate(vx, vy);
            gr.setColor(new Color(200, 200, 200, 128));
            gr.fill(window);
            gr.setColor(Color.BLACK);
            gr.drawRect(window.x, window.y, window.width - 1, window.height - 1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.moveVisibleRect(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void moveVisibleRect(Point center) {
        JComponent component = this.scene.getView();
        if (component == null) {
            return;
        }
        double zoomFactor = this.scene.getZoomFactor();
        Rectangle bounds = this.scene.getBounds();
        Dimension size = this.getSize();
        double sx = bounds.width > 0 ? (double)size.width / (double)bounds.width : 0.0;
        double sy = bounds.width > 0 ? (double)size.height / (double)bounds.height : 0.0;
        double scale = Math.min(sx, sy);
        int vw = (int)(scale * (double)bounds.width);
        int vh = (int)(scale * (double)bounds.height);
        int vx = (size.width - vw) / 2;
        int vy = (size.height - vh) / 2;
        int cx = (int)((double)(center.x - vx) / scale * zoomFactor);
        int cy = (int)((double)(center.y - vy) / scale * zoomFactor);
        Rectangle visibleRect = component.getVisibleRect();
        visibleRect.x = cx - visibleRect.width / 2;
        visibleRect.y = cy - visibleRect.height / 2;
        component.scrollRectToVisible(visibleRect);
    }

    @Override
    public void sceneRepaint() {
        this.repaint();
    }

    @Override
    public void sceneValidating() {
    }

    @Override
    public void sceneValidated() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

