/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Image;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.vmd.VMDGlyphSetWidget;
import org.netbeans.api.visual.vmd.VMDNodeAnchor;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class VMDPinWidget
extends Widget {
    private VMDColorScheme scheme;
    private LabelWidget nameWidget;
    private VMDGlyphSetWidget glyphsWidget;
    private VMDNodeAnchor anchor;

    public VMDPinWidget(Scene scene) {
        this(scene, VMDFactory.getOriginalScheme());
    }

    public VMDPinWidget(Scene scene, VMDColorScheme scheme) {
        super(scene);
        assert (scheme != null);
        this.scheme = scheme;
        this.setLayout(LayoutFactory.createHorizontalFlowLayout(LayoutFactory.SerialAlignment.CENTER, 8));
        this.nameWidget = new LabelWidget(scene);
        this.addChild(this.nameWidget);
        this.glyphsWidget = new VMDGlyphSetWidget(scene);
        this.addChild(this.glyphsWidget);
        scheme.installUI(this);
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    @Override
    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.scheme.updateUI(this, previousState, state);
    }

    public Widget getPinNameWidget() {
        return this.nameWidget;
    }

    public void setPinName(String name) {
        this.nameWidget.setLabel(name);
    }

    public String getPinName() {
        return this.nameWidget.getLabel();
    }

    public void setGlyphs(List<Image> glyphs) {
        this.glyphsWidget.setGlyphs(glyphs);
    }

    public void setProperties(String name, List<Image> glyphs) {
        this.setPinName(name);
        this.glyphsWidget.setGlyphs(glyphs);
    }

    public Anchor createAnchor() {
        if (this.anchor == null) {
            this.anchor = new VMDNodeAnchor(this, false);
        }
        return this.anchor;
    }
}

