/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lsp;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.lsp.InlayHint;
import org.netbeans.api.lsp.Range;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

@MimeLocation(subfolderName="CodeLensProvider")
public interface InlayHintsProvider {
    public Set<String> supportedHintTypes();

    public CompletableFuture<List<? extends InlayHint>> inlayHints(@NonNull Context var1);

    public static final class Context {
        @NonNull
        private final FileObject file;
        @NullAllowed
        private final Range range;
        @NonNull
        private final Set<String> requestedHintTypes;

        public Context(@NonNull FileObject file, @NullAllowed Range range, @NonNull Set<String> requestedHintTypes) {
            Parameters.notNull((CharSequence)"file", (Object)file);
            Parameters.notNull((CharSequence)"range", (Object)range);
            Parameters.notNull((CharSequence)"requestedHintTypes", requestedHintTypes);
            this.file = file;
            this.range = range;
            this.requestedHintTypes = Set.copyOf(requestedHintTypes);
        }

        @NonNull
        public FileObject getFile() {
            return this.file;
        }

        @CheckForNull
        public Range getRange() {
            return this.range;
        }

        @NonNull
        public Set<String> getRequestedHintTypes() {
            return this.requestedHintTypes;
        }
    }
}

