/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.netbeans.api.htmlui.OpenHTMLRegistration;
import org.openide.awt.ActionID;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class HTMLViewProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hash = new HashSet<String>();
        hash.add(OpenHTMLRegistration.class.getCanonicalName());
        return hash;
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment re) throws LayerGenerationException {
        for (Element element : re.getElementsAnnotatedWith(OpenHTMLRegistration.class)) {
            ActionID aid;
            OpenHTMLRegistration reg = element.getAnnotation(OpenHTMLRegistration.class);
            if (reg == null || element.getKind() != ElementKind.METHOD) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be static", element);
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be public", element);
            }
            if (!((ExecutableElement)element).getParameters().isEmpty()) {
                this.error("Method annotated by @OpenHTMLRegistration should have no arguments", element);
            }
            if (!element.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be public in a public class", element);
            }
            if ((aid = element.getAnnotation(ActionID.class)) != null) {
                LayerBuilder builder = this.layer(new Element[]{element});
                LayerBuilder.File actionFile = builder.file("Actions/" + aid.category() + "/" + aid.id().replace('.', '-') + ".instance").methodvalue("instanceCreate", "org.netbeans.modules.htmlui.Pages", "openAction");
                String abs = LayerBuilder.absolutizeResource((Element)element, (String)reg.url());
                try {
                    builder.validateResource(abs, element, (Annotation)reg, null, true);
                }
                catch (LayerGenerationException ex) {
                    if (System.getProperty("netbeans.home") != null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Cannot find resource " + abs, element);
                    }
                    throw ex;
                }
                actionFile.stringvalue("url", abs);
                if (!reg.iconBase().isEmpty()) {
                    actionFile.stringvalue("iconBase", reg.iconBase());
                }
                actionFile.stringvalue("method", element.getSimpleName().toString());
                actionFile.stringvalue("class", element.getEnclosingElement().asType().toString());
                String[] techIds = reg.techIds();
                for (int i = 0; i < techIds.length; ++i) {
                    actionFile.stringvalue("techId." + i, techIds[i]);
                }
                actionFile.bundlevalue("displayName", reg.displayName(), (Annotation)reg, "displayName");
                actionFile.write();
                continue;
            }
            this.error("@OpenHTMLRegistration needs to be accompanied with @ActionID annotation", element);
        }
        return true;
    }

    private void error(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }
}

