/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.run.Hyperlink;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public final class StandardLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(StandardLogger.class.getName());
    public static final int LOGGER_MAX_LINE_LENGTH = Integer.getInteger("logger.max.line.length", 3000);
    private static final Pattern CARET_SHOWING_COLUMN = Pattern.compile("^( *)\\^$");
    private static final Pattern CWD_ENTER = Pattern.compile(".*Entering directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    private static final Pattern CWD_LEAVE = Pattern.compile(".*Leaving directory [`'\"]?([^`'\"]+)(['\"]|$|\\.\\.\\.$)");
    public static final String USING_STANDARD_REDIRECTOR = "USING_STANDARD_REDIRECTOR";
    private final long mockTotalTime;
    private static final Pattern UNIMPORTANT_MESSAGE = Pattern.compile("\\[deprecation\\]|warning|stopped|cannot find symbol|wrong ELF class");
    private static final Pattern HYPERLINK = Pattern.compile("(\"?(.+?)\"?(?:(?::|, line )(\\d+)(?::(\\d+)(?::(\\d+):(\\d+))?)?)?)(: +(.*))");

    public StandardLogger() {
        this.mockTotalTime = 0L;
    }

    StandardLogger(long mockTotalTime) {
        this.mockTotalTime = mockTotalTime;
    }

    @Override
    public boolean interestedInSession(AntSession session) {
        return true;
    }

    @Override
    public boolean interestedInAllScripts(AntSession session) {
        return true;
    }

    @Override
    public String[] interestedInTargets(AntSession session) {
        return AntLogger.ALL_TARGETS;
    }

    @Override
    public String[] interestedInTasks(AntSession session) {
        return AntLogger.ALL_TASKS;
    }

    @Override
    public int[] interestedInLogLevels(AntSession session) {
        int verb = session.getVerbosity();
        assert (verb >= 0 && verb <= 4) : verb;
        int[] levels = new int[verb + 1];
        for (int i = 0; i <= verb; ++i) {
            levels[i] = i;
        }
        return levels;
    }

    private SessionData getSessionData(AntSession session) {
        SessionData data = (SessionData)session.getCustomData(this);
        if (data == null) {
            data = new SessionData();
            session.putCustomData(this, data);
        }
        return data;
    }

    @Override
    public void buildInitializationFailed(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        Throwable t = event.getException();
        if (event.getSession().getVerbosity() >= 3) {
            StandardLogger.deliverStackTrace(t, event);
        } else {
            event.getSession().println(t.toString(), true, null);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
        event.consume();
    }

    private static void deliverBlockOfTextAsLines(String lines, AntEvent originalEvent, int level) {
        StringTokenizer tok = new StringTokenizer(lines, "\r\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            originalEvent.getSession().deliverMessageLogged(originalEvent, line, level);
        }
    }

    private static void deliverStackTrace(Throwable t, AntEvent originalEvent) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        StandardLogger.deliverBlockOfTextAsLines(sw.toString(), originalEvent, 0);
    }

    @Override
    public void buildStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        AntSession session = event.getSession();
        this.getSessionData((AntSession)session).startTime = System.currentTimeMillis();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_running_ant", (Object)session.getDisplayName()));
        if (!session.getOriginatingScript().getParentFile().getName().equals("executor-snippets")) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("ant");
            switch (session.getVerbosity()) {
                case 4: {
                    cmd.add("-d");
                    break;
                }
                case 3: {
                    cmd.add("-v");
                    break;
                }
                case 1: {
                    cmd.add("-q");
                }
            }
            cmd.add("-f");
            File script = session.getOriginatingScript();
            if (script.getName().equals("build.xml")) {
                script = script.getParentFile();
            }
            cmd.add(script.getAbsolutePath());
            for (Map.Entry<String, String> prop : session.getProperties().entrySet()) {
                String key = prop.getKey();
                if (key.equals("build.compiler.emacs")) continue;
                String value = prop.getValue();
                if (session.isConcealed(key)) {
                    value = "*****";
                }
                cmd.add(String.format("-D%s=%s", key, value));
            }
            for (String target : session.getOriginatingTargets()) {
                cmd.add(target);
            }
            String msg = Utilities.escapeParameters((String[])cmd.toArray(new String[cmd.size()]));
            InputOutput io = session.getIO();
            if (IOColorLines.isSupported((InputOutput)io)) {
                try {
                    IOColorLines.println((InputOutput)io, (CharSequence)msg, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
                }
                catch (IOException x) {
                    ERR.log(Level.INFO, null, x);
                }
            } else {
                session.println(msg.toString(), false, null);
            }
        }
        event.consume();
    }

    @Override
    public void buildFinished(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        AntSession session = event.getSession();
        Throwable t = event.getException();
        long time = System.currentTimeMillis() - this.getSessionData((AntSession)session).startTime;
        if (this.mockTotalTime != 0L) {
            time = this.mockTotalTime;
        }
        if (t == null) {
            StandardLogger.formatColoredMessageWithTime(session, "FMT_finished_target_printed", false, time);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_finished_target_status", (Object)session.getDisplayName()));
        } else {
            if (StandardLogger.isStopException(t.getCause())) {
                t = t.getCause();
            }
            if (!session.isExceptionConsumed(t)) {
                String msg2;
                String msg1;
                Throwable cause;
                session.consumeException(t);
                StringBuilder msg = new StringBuilder();
                while (StandardLogger.isBuildException(t) && (cause = t.getCause()) != null && (msg1 = t.toString()).endsWith(msg2 = cause.toString())) {
                    msg.append(msg1.substring(0, msg1.length() - msg2.length()));
                    t = cause;
                }
                if (StandardLogger.isBuildException(t) && session.getVerbosity() < 3) {
                    msg.append(t);
                    StandardLogger.deliverBlockOfTextAsLines(msg.toString(), event, 0);
                } else if (!StandardLogger.isStopException(t) || event.getSession().getVerbosity() >= 3) {
                    if (msg.length() > 0) {
                        StandardLogger.deliverBlockOfTextAsLines(msg.toString(), event, 0);
                    }
                    StandardLogger.deliverStackTrace(t, event);
                }
            }
            if (StandardLogger.isStopException(t)) {
                StandardLogger.formatColoredMessageWithTime(session, "FMT_target_stopped_printed", true, time);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_stopped_status", (Object)event.getSession().getDisplayName()));
            } else {
                StandardLogger.formatColoredMessageWithTime(session, "FMT_target_failed_printed", true, time);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(StandardLogger.class, (String)"FMT_target_failed_status", (Object)event.getSession().getDisplayName()));
            }
        }
        event.consume();
    }

    private static boolean isBuildException(Throwable t) {
        for (Class<?> c = t.getClass(); c != Throwable.class; c = c.getSuperclass()) {
            if (!c.getName().equals("org.apache.tools.ant.BuildException")) continue;
            return true;
        }
        return false;
    }

    private static boolean isStopException(Throwable t) {
        return t instanceof ThreadDeath || t instanceof InterruptedException;
    }

    private static void formatColoredMessageWithTime(AntSession session, String key, boolean error, long millis) {
        int secs = (int)(millis / 1000L);
        int minutes = secs / 60;
        int seconds = secs % 60;
        String msg = NbBundle.getMessage(StandardLogger.class, (String)key, (Object)minutes, (Object)seconds);
        InputOutput io = session.getIO();
        if (IOColorLines.isSupported((InputOutput)io)) {
            try {
                IOColorLines.println((InputOutput)io, (CharSequence)msg, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)(error ? IOColors.OutputType.LOG_FAILURE : IOColors.OutputType.LOG_SUCCESS)));
                return;
            }
            catch (IOException x) {
                ERR.log(Level.INFO, null, x);
            }
        }
        session.println(msg, error, null);
    }

    @Override
    public void targetStarted(AntEvent event) {
        if (event.isConsumed()) {
            return;
        }
        String name = event.getTargetName();
        if (name != null) {
            int minlevel = name.length() > 0 && name.charAt(0) == '-' ? 3 : 2;
            AntSession session = event.getSession();
            if (session.getVerbosity() >= minlevel) {
                String projectName;
                if (!session.getOriginatingScript().getAbsolutePath().equals(event.getProperty("ant.file")) && (projectName = event.getProperty("ant.project.name")) != null && !projectName.contains("{0}")) {
                    name = projectName + '.' + name;
                }
                String msg = NbBundle.getMessage(StandardLogger.class, (String)"MSG_target_started_printed", (Object)name);
                InputOutput io = session.getIO();
                if (IOColorLines.isSupported((InputOutput)io)) {
                    try {
                        IOColorLines.println((InputOutput)io, (CharSequence)msg, (Color)IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
                    }
                    catch (IOException x) {
                        ERR.log(Level.INFO, null, x);
                    }
                } else {
                    session.println(msg, false, null);
                }
            }
        }
        event.consume();
    }

    @Override
    public void messageLogged(AntEvent event) {
        Stack<File> stack;
        File d;
        if (event.isConsumed()) {
            return;
        }
        event.consume();
        AntSession session = event.getSession();
        String line = event.getMessage();
        if (line.startsWith("Trying to override old definition of ") && event.getLogLevel() == 1) {
            session.deliverMessageLogged(event, line, 3);
            return;
        }
        ERR.log(Level.FINE, "Received message: {0}", line);
        if (line.indexOf(10) != -1) {
            StandardLogger.deliverBlockOfTextAsLines(line, event, event.getLogLevel());
            return;
        }
        if (line.length() >= LOGGER_MAX_LINE_LENGTH) {
            if (!StandardLogger.isRedirectedJavaOutput(event)) {
                session.println(line, false, null);
            }
            return;
        }
        Matcher m = CARET_SHOWING_COLUMN.matcher(line);
        if (m.matches()) {
            ERR.fine("  Looks like a special caret line");
            SessionData data = this.getSessionData(session);
            if (data.lastHyperlink != null) {
                data.lastHyperlink.setColumn1(m.group(1).length() + 1);
                data.lastHyperlink = null;
                return;
            }
        }
        if ((m = CWD_ENTER.matcher(line)).matches()) {
            ERR.fine("  Looks like a change of CWD");
            d = new File(m.group(1));
            if (d.isDirectory()) {
                stack = this.getSessionData((AntSession)session).currentDir;
                stack.push(d);
                ERR.log(Level.FINE, "  ...is a change of CWD; stack now: {0}", stack);
            }
        }
        if ((m = CWD_LEAVE.matcher(line)).matches()) {
            ERR.fine("  Looks like a change of CWD back out");
            d = new File(m.group(1));
            stack = this.getSessionData((AntSession)session).currentDir;
            if (stack.empty()) {
                ERR.log(Level.FINE, "  ...but there was nowhere to change out of");
            } else {
                File previous = stack.pop();
                if (!previous.equals(d)) {
                    ERR.log(Level.FINE, "  ...stack mismatch: {0} vs. {1}", new Object[]{previous, d});
                }
            }
        }
        if (StandardLogger.isRedirectedJavaOutput(event)) {
            return;
        }
        PartiallyLinkedLine parse = StandardLogger.findHyperlink(line, event.getSession(), this.getSessionData((AntSession)session).currentDir);
        if (parse.hyperlink instanceof Hyperlink) {
            this.getSessionData((AntSession)session).lastHyperlink = (Hyperlink)parse.hyperlink;
        }
        parse.println(event.getSession(), event.getLogLevel() <= 1);
    }

    private static boolean isRedirectedJavaOutput(AntEvent event) {
        return "java".equals(event.getTaskName()) && event.getProperty(USING_STANDARD_REDIRECTOR) == null && (event.getLogLevel() == 1 || event.getLogLevel() == 2);
    }

    @Override
    public void taskFinished(AntEvent event) {
        this.getSessionData((AntSession)event.getSession()).lastHyperlink = null;
    }

    public static boolean isImportant(String message) {
        if (message.length() >= LOGGER_MAX_LINE_LENGTH) {
            return false;
        }
        return !UNIMPORTANT_MESSAGE.matcher(message).find();
    }

    public static PartiallyLinkedLine findHyperlink(String line, AntSession session, Stack<File> cwd) {
        File file;
        if (line.length() >= LOGGER_MAX_LINE_LENGTH) {
            return new PartiallyLinkedLine(line);
        }
        Matcher m = HYPERLINK.matcher(line);
        if (!m.matches()) {
            ERR.fine("does not look like a hyperlink");
            return new PartiallyLinkedLine(line);
        }
        String path = m.group(2);
        if (path.startsWith("file:")) {
            try {
                file = Utilities.toFile((URI)new URI(path));
            }
            catch (URISyntaxException e) {
                ERR.log(Level.FINE, "invalid URI, skipping", e);
                return new PartiallyLinkedLine(line);
            }
            catch (IllegalArgumentException e) {
                ERR.log(Level.FINE, "invalid URI, skipping", e);
                return new PartiallyLinkedLine(line);
            }
        } else {
            file = new File(path);
            if (!file.isAbsolute()) {
                if (cwd == null || cwd.isEmpty()) {
                    ERR.fine("Non-absolute path with no CWD, skipping");
                    return new PartiallyLinkedLine(line);
                }
                file = new File(cwd.peek(), path);
            }
        }
        if (!file.exists()) {
            ERR.log(Level.FINE, "no such file {0}, skipping", file);
            return new PartiallyLinkedLine(line);
        }
        int line1 = -1;
        int col1 = -1;
        int line2 = -1;
        int col2 = -1;
        String num = m.group(3);
        try {
            if (num != null) {
                line1 = Integer.parseInt(num);
                num = m.group(4);
                if (num != null) {
                    col1 = Integer.parseInt(num);
                    num = m.group(5);
                    if (num != null) {
                        line2 = Integer.parseInt(num);
                        col2 = Integer.parseInt(m.group(6));
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            ERR.log(Level.FINE, "bad line/col #", e);
            return new PartiallyLinkedLine(line);
        }
        String message = m.group(8);
        file = FileUtil.normalizeFile((File)file);
        ERR.log(Level.FINE, "Hyperlink: {0} [{1}:{2}:{3}:{4}]: {5}", new Object[]{file, line1, col1, line2, col2, message});
        try {
            return new PartiallyLinkedLine(session.createStandardHyperlink(Utilities.toURI((File)file).toURL(), message, line1, col1, line2, col2), line, m.group(1), m.group(7));
        }
        catch (MalformedURLException e) {
            assert (false) : e;
            return new PartiallyLinkedLine(line);
        }
    }

    public static class PartiallyLinkedLine {
        final OutputListener hyperlink;
        final String all;
        final String mainPart;
        final String postLinkPart;

        PartiallyLinkedLine(String line) {
            this(null, line, null, null);
        }

        PartiallyLinkedLine(OutputListener hyperlink, String all, String mainPart, String postLinkPart) {
            this.hyperlink = hyperlink;
            this.all = all;
            this.mainPart = mainPart;
            this.postLinkPart = postLinkPart;
        }

        public void println(AntSession session, boolean err) {
            if (this.hyperlink != null) {
                InputOutput io = session.getIO();
                if (IOColorPrint.isSupported((InputOutput)io)) {
                    try {
                        assert (this.mainPart != null);
                        IOColorPrint.print((InputOutput)io, (CharSequence)this.mainPart, (OutputListener)this.hyperlink, (boolean)StandardLogger.isImportant(this.all), null);
                        assert (this.postLinkPart != null);
                        session.println(this.postLinkPart, true, null);
                        return;
                    }
                    catch (IOException x) {
                        ERR.log(Level.INFO, null, x);
                    }
                }
                session.println(this.all, err, this.hyperlink);
            } else {
                session.println(this.all, err, null);
            }
        }
    }

    private static final class SessionData {
        public long startTime;
        public Hyperlink lastHyperlink;
        public Stack<File> currentDir = new Stack();
    }
}

