/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.run.AdvancedActionPanel;
import org.apache.tools.ant.module.run.LastTargetExecuted;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.w3c.dom.Element;

public final class TargetExecutor
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(TargetExecutor.class.getName(), Integer.MAX_VALUE);
    private static final Map<InputOutput, Pair<String, Predicate<String>>> freeTabs = new WeakHashMap<InputOutput, Pair<String, Predicate<String>>>();
    private static final Set<String> activeDisplayNames = new HashSet<String>();
    private AntProjectCookie pcookie;
    private InputOutput io;
    private OutputStream outputStream;
    private boolean ok = false;
    private int verbosity = AntSettings.getVerbosity();
    private Map<String, String> properties = AntSettings.getProperties();
    private List<String> targetNames;
    private String displayName;
    private String suggestedDisplayName;
    private Boolean shouldSaveAllDocs;
    private Predicate<String> canReplace = s -> true;
    private Predicate<String> canBeReplaced = s -> true;
    private boolean userAction = true;
    private volatile Set<String> concealedProperties;
    private static final Map<InputOutput, StopAction> stopActions = new HashMap<InputOutput, StopAction>();
    private static final Map<InputOutput, RerunAction[]> rerunActions = new HashMap<InputOutput, RerunAction[]>();

    public TargetExecutor(AntProjectCookie pcookie, String[] targets) {
        this.pcookie = pcookie;
        this.targetNames = targets == null ? null : Arrays.asList(targets);
        this.concealedProperties = Collections.emptySet();
    }

    public void setVerbosity(int v) {
        this.verbosity = v;
    }

    public synchronized void setProperties(Map<String, String> p) {
        this.properties = new HashMap<String, String>(p);
    }

    public void setConcealedProperties(@NonNull Set<? extends String> concealedProperties) {
        Parameters.notNull((CharSequence)"concealedProperties", concealedProperties);
        this.concealedProperties = Collections.unmodifiableSet(new HashSet<String>(concealedProperties));
    }

    public void setSaveAllDocuments(boolean shouldSaveAllDocs) {
        this.shouldSaveAllDocs = shouldSaveAllDocs;
    }

    public void setDisplayName(String n) {
        this.suggestedDisplayName = n;
    }

    public void setTabReplaceStrategy(@NonNull Predicate<String> canReplace, @NonNull Predicate<String> canBeReplaced) {
        Parameters.notNull((CharSequence)"canReplace", canReplace);
        Parameters.notNull((CharSequence)"canBeReplaced", canBeReplaced);
        this.canReplace = canReplace;
        this.canBeReplaced = canBeReplaced;
    }

    public void setUserAction(boolean userAction) {
        this.userAction = userAction;
    }

    private static String getProcessDisplayName(AntProjectCookie pcookie, List<String> targetNames) {
        Element projel = pcookie.getProjectElement();
        String projectName = projel != null ? Actions.cutAmpersand((String)projel.getAttribute("name")) : NbBundle.getMessage(TargetExecutor.class, (String)"LBL_unparseable_proj_name");
        String fileName = pcookie.getFileObject() != null ? pcookie.getFileObject().getNameExt() : (pcookie.getFile() != null ? pcookie.getFile().getName() : "");
        if (projectName.equals("")) {
            projectName = fileName;
        }
        if (targetNames != null) {
            StringBuffer targetList = new StringBuffer();
            Iterator<String> it = targetNames.iterator();
            if (it.hasNext()) {
                targetList.append(it.next());
            }
            while (it.hasNext()) {
                targetList.append(NbBundle.getMessage(TargetExecutor.class, (String)"SEP_output_target"));
                targetList.append(it.next());
            }
            return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_target", (Object)projectName, (Object)fileName, (Object)targetList);
        }
        return NbBundle.getMessage(TargetExecutor.class, (String)"TITLE_output_notarget", (Object)projectName, (Object)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute() throws IOException {
        ExecutorTask task;
        Object testdn;
        String dn = this.suggestedDisplayName != null ? this.suggestedDisplayName : TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames);
        Set<String> set = activeDisplayNames;
        synchronized (set) {
            if (activeDisplayNames.contains(dn)) {
                int i = 2;
                while (activeDisplayNames.contains(testdn = NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.uniquified", (Object)dn, (Object)i++))) {
                }
                dn = testdn;
            }
            assert (!activeDisplayNames.contains(dn));
            this.displayName = dn;
            activeDisplayNames.add(this.displayName);
        }
        TargetExecutor i = this;
        synchronized (i) {
            if (AntSettings.getAutoCloseTabs()) {
                testdn = freeTabs;
                synchronized (testdn) {
                    HashSet<InputOutput> retained = new HashSet<InputOutput>();
                    for (Map.Entry<InputOutput, Pair<String, Predicate<String>>> entry : freeTabs.entrySet()) {
                        InputOutput free = entry.getKey();
                        String freeName = (String)entry.getValue().first();
                        Predicate freePredicate = (Predicate)entry.getValue().second();
                        if (this.io == null && freeName.equals(this.displayName)) {
                            this.io = free;
                            this.io.getOut().reset();
                            continue;
                        }
                        if (this.canReplace.test(freeName) && freePredicate.test(this.displayName)) {
                            free.closeInputOutput();
                            stopActions.remove(free);
                            rerunActions.remove(free);
                            continue;
                        }
                        retained.add(free);
                    }
                    freeTabs.keySet().retainAll(retained);
                }
            }
            if (this.io == null) {
                StopAction sa = new StopAction();
                RerunAction[] ras = new RerunAction[]{new RerunAction(this, false), new RerunAction(this, true)};
                this.io = IOProvider.getDefault().getIO(this.displayName, new Action[]{ras[0], ras[1], sa, new OptionsAction()});
                stopActions.put(this.io, sa);
                rerunActions.put(this.io, ras);
            }
            task = ExecutionEngine.getDefault().execute(this.displayName, (Runnable)this, InputOutput.NULL);
        }
        WrapperExecutorTask wrapper = new WrapperExecutorTask(task, this.io);
        RP.post((Runnable)((Object)wrapper));
        return wrapper;
    }

    public ExecutorTask execute(OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        ExecutorTask task = ExecutionEngine.getDefault().execute(null, (Runnable)this, InputOutput.NULL);
        return new WrapperExecutorTask(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void run() {
        Object object;
        RerunAction[] ras;
        StopAction sa;
        LastTargetExecuted[] thisExec;
        block41: {
            File buildFile;
            OutputWriter err;
            OutputWriter out;
            AtomicBoolean displayed;
            block39: {
                block40: {
                    thisExec = new LastTargetExecuted[1];
                    sa = stopActions.get(this.io);
                    assert (sa != null);
                    ras = rerunActions.get(this.io);
                    assert (ras != null);
                    displayed = new AtomicBoolean(AntSettings.getAlwaysShowOutput());
                    if (this.outputStream == null) {
                        if (displayed.get()) {
                            this.io.select();
                        } else if (IOSelect.isSupported((InputOutput)this.io)) {
                            Set<String> set = activeDisplayNames;
                            // MONITORENTER : set
                            boolean onlyProcessRunning = activeDisplayNames.size() == 1;
                            // MONITOREXIT : set
                            if (onlyProcessRunning) {
                                IOSelect.select((InputOutput)this.io, EnumSet.noneOf(IOSelect.AdditionalOperation.class));
                            }
                        }
                    }
                    if (this.shouldSaveAllDocs != null ? this.shouldSaveAllDocs != false : AntSettings.getSaveAll()) {
                        LifecycleManager.getDefault().saveAll();
                    }
                    if (this.outputStream != null) throw new RuntimeException("XXX No support for outputStream currently!");
                    out = this.io.getOut();
                    err = this.io.getErr();
                    buildFile = this.pcookie.getFile();
                    if (buildFile != null) break block39;
                    err.println(NbBundle.getMessage(TargetExecutor.class, (String)"EXC_non_local_proj_file"));
                    if (this.io == null) break block40;
                    Map<InputOutput, Pair<String, Predicate<String>>> map = freeTabs;
                    // MONITORENTER : map
                    freeTabs.put(this.io, (Pair<String, Predicate<String>>)Pair.of((Object)this.displayName, this.canBeReplaced));
                    // MONITOREXIT : map
                }
                if (thisExec[0] != null) {
                    LastTargetExecuted.finish(thisExec[0]);
                }
                sa.t = null;
                TargetExecutor.setEnabledEQ(sa, false);
                RerunAction[] rerunActionArray = ras;
                int n = rerunActionArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        Set<String> set = activeDisplayNames;
                        // MONITORENTER : set
                        activeDisplayNames.remove(this.displayName);
                        // MONITOREXIT : set
                        return;
                    }
                    RerunAction ra = rerunActionArray[n2];
                    TargetExecutor.setEnabledEQ(ra, true);
                    ra.reinit(this);
                    ++n2;
                }
            }
            try {
                thisExec[0] = LastTargetExecuted.record(buildFile, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null, this.properties, this.concealedProperties, this.suggestedDisplayName != null ? this.suggestedDisplayName : TargetExecutor.getProcessDisplayName(this.pcookie, this.targetNames), this.shouldSaveAllDocs, this.canReplace, this.canBeReplaced, Thread.currentThread(), this.userAction);
                sa.t = thisExec[0];
                Thread.currentThread().setPriority(3);
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!displayed.getAndSet(true)) {
                            TargetExecutor.this.io.select();
                        }
                    }
                };
                AtomicReference<2> in = new AtomicReference<2>();
                if (this.outputStream == null) {
                    try {
                        in.set(new ReaderInputStream(this.io.getIn()){

                            public int read() throws IOException {
                                runnable.run();
                                return super.read();
                            }

                            public int read(byte[] b) throws IOException {
                                runnable.run();
                                return super.read(b);
                            }

                            public int read(byte[] b, int off, int len) throws IOException {
                                runnable.run();
                                return super.read(b, off, len);
                            }

                            public long skip(long n) throws IOException {
                                runnable.run();
                                return super.skip(n);
                            }
                        });
                    }
                    catch (IOException e) {
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
                ProgressHandle handle = ProgressHandle.createHandle((String)this.displayName, (Cancellable)new Cancellable(){

                    public boolean cancel() {
                        sa.actionPerformed(null);
                        return true;
                    }
                }, (Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TargetExecutor.this.io.select();
                    }
                });
                handle.setInitialDelay(0);
                handle.start();
                TargetExecutor.setEnabledEQ(sa, true);
                for (RerunAction ra : ras) {
                    TargetExecutor.setEnabledEQ(ra, false);
                }
                this.ok = AntBridge.getInterface().run(buildFile, this.targetNames, (InputStream)in.get(), out, err, this.properties, this.concealedProperties, this.verbosity, this.displayName, runnable, handle, this.io);
                if (this.io == null) break block41;
                object = freeTabs;
            }
            catch (Throwable throwable) {
                Object object2;
                if (this.io != null) {
                    object2 = freeTabs;
                    // MONITORENTER : freeTabs
                    freeTabs.put(this.io, (Pair<String, Predicate<String>>)Pair.of((Object)this.displayName, this.canBeReplaced));
                    // MONITOREXIT : object2
                }
                if (thisExec[0] != null) {
                    LastTargetExecuted.finish(thisExec[0]);
                }
                sa.t = null;
                TargetExecutor.setEnabledEQ(sa, false);
                object2 = ras;
                int n = ((RerunAction[])object2).length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n) {
                        object2 = activeDisplayNames;
                        // MONITORENTER : object2
                        activeDisplayNames.remove(this.displayName);
                        // MONITOREXIT : object2
                        throw throwable;
                    }
                    RerunAction ra = object2[n3];
                    TargetExecutor.setEnabledEQ(ra, true);
                    ra.reinit(this);
                    ++n3;
                }
            }
            // MONITORENTER : freeTabs
            freeTabs.put(this.io, (Pair<String, Predicate<String>>)Pair.of((Object)this.displayName, this.canBeReplaced));
            // MONITOREXIT : object
        }
        if (thisExec[0] != null) {
            LastTargetExecuted.finish(thisExec[0]);
        }
        sa.t = null;
        TargetExecutor.setEnabledEQ(sa, false);
        object = ras;
        int n = ((RerunAction[])object).length;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                object = activeDisplayNames;
                // MONITORENTER : object
                activeDisplayNames.remove(this.displayName);
                // MONITOREXIT : object
                return;
            }
            RerunAction ra = object[n4];
            TargetExecutor.setEnabledEQ(ra, true);
            ra.reinit(this);
            ++n4;
        }
    }

    static void stopProcess(Thread t) {
        AntBridge.getInterface().stop(t);
    }

    private static void setEnabledEQ(final Action a, final boolean enabled) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                a.setEnabled(enabled);
            }
        });
    }

    private static class WrapperRunnable
    implements Runnable {
        private final ExecutorTask task;

        public WrapperRunnable(ExecutorTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;
        private InputOutput io;

        public WrapperExecutorTask(ExecutorTask task, InputOutput io) {
            super((Runnable)new WrapperRunnable(task));
            this.task = task;
            this.io = io;
        }

        public void stop() {
            StopAction sa = (StopAction)stopActions.get(this.io);
            if (sa != null) {
                sa.actionPerformed(null);
            } else {
                this.task.stop();
            }
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return this.io;
        }
    }

    private static final class OptionsAction
    extends AbstractAction {
        private OptionsAction() {
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/options.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.OptionsAction");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDisplayer.getDefault().open("Java/Ant");
        }
    }

    private static final class RerunAction
    extends AbstractAction
    implements FileChangeListener {
        private final boolean withModifications;
        private AntProjectCookie pcookie;
        private List<String> targetNames;
        private int verbosity;
        private Map<String, String> properties;
        private Set<String> concealedProperties;
        private String displayName;
        private Boolean shouldSaveAllDocs;
        private Predicate<String> canReplace;
        private Predicate<String> canBeReplaced;

        public RerunAction(TargetExecutor prototype, boolean withModifications) {
            this.withModifications = withModifications;
            this.reinit(prototype);
            TargetExecutor.setEnabledEQ(this, false);
            FileObject script = this.pcookie.getFileObject();
            if (script != null) {
                script.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)script));
            }
        }

        private void reinit(TargetExecutor prototype) {
            this.pcookie = prototype.pcookie;
            this.targetNames = prototype.targetNames;
            this.verbosity = prototype.verbosity;
            this.properties = prototype.properties;
            this.concealedProperties = prototype.concealedProperties;
            this.displayName = prototype.suggestedDisplayName;
            this.shouldSaveAllDocs = prototype.shouldSaveAllDocs;
            this.canReplace = prototype.canReplace;
            this.canBeReplaced = prototype.canBeReplaced;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                if (this.withModifications) {
                    return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun-mod.png"));
                }
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/rerun.png"));
            }
            if (key.equals("ShortDescription")) {
                if (this.withModifications) {
                    return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun_different");
                }
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.RerunAction.rerun");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            try {
                if (this.withModifications) {
                    AdvancedActionPanel panel = new AdvancedActionPanel(this.pcookie, TargetLister.getTargets(this.pcookie));
                    panel.setTargets(this.targetNames);
                    panel.setVerbosity(this.verbosity);
                    panel.setProperties(this.properties);
                    panel.setConcealedProperties(this.concealedProperties);
                    if (!panel.display()) {
                        this.setEnabled(true);
                    }
                } else {
                    TargetExecutor exec = new TargetExecutor(this.pcookie, this.targetNames != null ? this.targetNames.toArray(new String[this.targetNames.size()]) : null);
                    exec.setProperties(this.properties);
                    exec.setConcealedProperties(this.concealedProperties);
                    if (this.displayName != null) {
                        exec.setDisplayName(this.displayName);
                    }
                    if (this.shouldSaveAllDocs != null) {
                        exec.setSaveAllDocuments(this.shouldSaveAllDocs);
                    }
                    exec.setTabReplaceStrategy(this.canReplace, this.canBeReplaced);
                    exec.execute();
                }
            }
            catch (IOException x) {
                Logger.getLogger(TargetExecutor.class.getName()).log(Level.INFO, null, x);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.firePropertyChange("enabled", null, false);
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.pcookie.getFileObject() != null && this.pcookie.getFileObject().isValid();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        public LastTargetExecuted t;

        public StopAction() {
            TargetExecutor.setEnabledEQ(this, false);
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(TargetExecutor.class.getResource("/org/apache/tools/ant/module/resources/stop.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getMessage(TargetExecutor.class, (String)"TargetExecutor.StopAction.stop");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (this.t != null) {
                this.t.stopRunning();
            }
        }
    }
}

