/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.api.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbCollections;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetLister {
    private TargetLister() {
    }

    public static Set<Target> getTargets(AntProjectCookie script) throws IOException {
        HashSet<File> alreadyImported = new HashSet<File>();
        Map properties = NbCollections.checkedMapByCopy((Map)System.getProperties(), String.class, String.class, (boolean)false);
        properties.putAll(AntSettings.getProperties());
        Script main = new Script(null, script, alreadyImported, properties, Collections.emptyMap());
        HashSet<Target> targets = new HashSet<Target>();
        HashSet<AntProjectCookie> visitedScripts = new HashSet<AntProjectCookie>();
        TargetLister.traverseScripts(main, targets, visitedScripts);
        return targets;
    }

    private static void traverseScripts(Script script, Set<Target> targets, Set<AntProjectCookie> visitedScripts) throws IOException {
        if (!visitedScripts.add(script.getScript())) {
            return;
        }
        targets.addAll(script.getTargets());
        for (Script imported : script.getImports()) {
            TargetLister.traverseScripts(imported, targets, visitedScripts);
        }
    }

    private static final class Script {
        private final AntProjectCookie apc;
        private final Script importingScript;
        private final Map<String, Target> targets;
        private final String defaultTarget;
        private final List<Script> imports;
        private final String name;
        private static final Set<String> TRUE_VALS = new HashSet<String>(5);

        public Script(Script importingScript, AntProjectCookie apc, Set<File> alreadyImported, Map<String, String> inheritedPropertyDefs, Map<String, Element> inheritedMacroDefs) throws IOException {
            String _defaultTarget;
            this.importingScript = importingScript;
            this.apc = apc;
            Element prj = apc.getProjectElement();
            if (prj == null) {
                throw new IOException(apc.getParseException() != null ? apc.getParseException().getLocalizedMessage() : "Could not parse file");
            }
            File prjFile = apc.getFile();
            if (prjFile != null) {
                alreadyImported.add(prjFile);
            }
            this.defaultTarget = (_defaultTarget = prj.getAttribute("default")).length() > 0 ? _defaultTarget : null;
            String _name = prj.getAttribute("name");
            this.name = _name.length() > 0 ? _name : null;
            String basedirS = prj.getAttribute("basedir");
            File _basedir = new File(basedirS = basedirS.length() == 0 ? "." : basedirS.replace('/', File.separatorChar).replace('\\', File.separatorChar));
            File basedir = _basedir.isAbsolute() ? _basedir : (prjFile != null ? new File(prjFile.getParentFile(), basedirS) : null);
            this.targets = new HashMap<String, Target>();
            HashMap<String, String> propertyDefs = new HashMap<String, String>(inheritedPropertyDefs);
            if (basedir != null && !propertyDefs.containsKey("basedir")) {
                propertyDefs.put("basedir", basedir.getAbsolutePath());
            }
            HashMap<String, Element> macroDefs = new HashMap<String, Element>(inheritedMacroDefs);
            this.imports = new ArrayList<Script>();
            this.interpretTasks(alreadyImported, prj, basedir, propertyDefs, macroDefs, null);
        }

        /*
         * WARNING - void declaration
         */
        private void interpretTasks(Set<File> alreadyImported, Element container, File basedir, Map<String, String> propertyDefs, Map<String, Element> macroDefs, Map<String, String> macroParams) throws IOException {
            NodeList nl = container.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                String macrodefName;
                Element macro;
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Element el = (Element)n;
                String elName = el.getLocalName();
                assert (elName != null) : "#76349: null localName from " + el;
                String fullname = elName;
                String uri = el.getNamespaceURI();
                if (uri != null) {
                    fullname = uri + '#' + fullname;
                }
                if ((macro = macroDefs.get(fullname)) != null) {
                    void var18_19;
                    HashMap<String, String> newMacroParams = new HashMap<String, String>();
                    NodeList macroKids = macro.getChildNodes();
                    boolean bl = false;
                    while (var18_19 < macroKids.getLength()) {
                        if (macroKids.item((int)var18_19).getNodeType() == 1) {
                            Element el2 = (Element)macroKids.item((int)var18_19);
                            String elName2 = el2.getLocalName();
                            if (elName2.equals("attribute")) {
                                String attrVal;
                                String attrValSubst;
                                String attrName = el2.getAttribute("name");
                                if (attrName.length() != 0 && (attrValSubst = Script.replaceAntProperties(attrVal = el.getAttribute(attrName), propertyDefs)) != null) {
                                    newMacroParams.put(attrName, attrValSubst);
                                }
                            } else if (elName2.equals("sequential")) {
                                this.interpretTasks(alreadyImported, el2, basedir, propertyDefs, macroDefs, newMacroParams);
                            }
                        }
                        ++var18_19;
                    }
                    continue;
                }
                if (macroParams == null && elName.equals("target")) {
                    String targetName = el.getAttribute("name");
                    this.targets.put(targetName, new Target(this, el, targetName));
                    continue;
                }
                if (macroParams == null && elName.equals("import")) {
                    File file;
                    String fileSubstituted;
                    String fileS = el.getAttribute("file").replace('/', File.separatorChar).replace('\\', File.separatorChar);
                    if ("".equals(fileS) || (fileSubstituted = Script.replaceAntProperties(fileS, propertyDefs)).indexOf("${") != -1) continue;
                    File file2 = new File(fileSubstituted);
                    if (file2.isAbsolute()) {
                        file = file2;
                    } else {
                        if (this.apc.getFile() == null) continue;
                        file = new File(this.apc.getFile().getParentFile(), fileSubstituted);
                    }
                    file = FileUtil.normalizeFile((File)file);
                    if (alreadyImported.contains(file)) continue;
                    if (file.canRead()) {
                        FileObject fileObj = FileUtil.toFileObject((File)file);
                        assert (fileObj != null) : file;
                        AntProjectCookie importedApc = AntScriptUtils.antProjectCookieFor(fileObj);
                        this.imports.add(new Script(this, importedApc, alreadyImported, propertyDefs, macroDefs));
                        continue;
                    }
                    String optionalS = el.getAttribute("optional");
                    boolean optional = TRUE_VALS.contains(optionalS.toLowerCase(Locale.US));
                    if (optional) continue;
                    throw new IOException("Cannot find import " + file + " from " + this.apc);
                }
                if (elName.equals("property")) {
                    void var18_25;
                    String file;
                    if (el.hasAttribute("value")) {
                        String propertyName = Script.replaceMacroParams(el.getAttribute("name"), macroParams);
                        if (propertyName.length() == 0 || propertyDefs.containsKey(propertyName)) continue;
                        String value = Script.replaceMacroParams(el.getAttribute("value"), macroParams);
                        String string = Script.replaceAntProperties(value, propertyDefs);
                        propertyDefs.put(propertyName, string);
                        continue;
                    }
                    if (el.hasAttribute("environment")) {
                        String envPrefix = el.getAttribute("environment") + ".";
                        for (Map.Entry entry : System.getenv().entrySet()) {
                            propertyDefs.put(envPrefix + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    if ((file = Script.replaceMacroParams(el.getAttribute("file"), macroParams)).length() <= 0) continue;
                    String fileSubst = Script.replaceAntProperties(file, propertyDefs);
                    File file3 = new File(fileSubst);
                    if (!file3.isAbsolute() && basedir != null) {
                        File file4 = new File(basedir, fileSubst.replace('/', File.separatorChar).replace('\\', File.separatorChar));
                    }
                    if (!var18_25.canRead()) continue;
                    Properties p = new Properties();
                    try (FileInputStream is = new FileInputStream((File)var18_25);){
                        p.load(is);
                    }
                    Map<String, String> evaluatedProperties = Script.evaluateAll(propertyDefs, Collections.singletonList(NbCollections.checkedMapByFilter((Map)p, String.class, String.class, (boolean)true)));
                    if (evaluatedProperties == null) continue;
                    for (Map.Entry<String, String> entry : evaluatedProperties.entrySet()) {
                        String k = entry.getKey();
                        if (propertyDefs.containsKey(k)) continue;
                        propertyDefs.put(k, entry.getValue());
                    }
                    continue;
                }
                if (!elName.equals("macrodef") || (macrodefName = el.getAttribute("name")).length() == 0) continue;
                uri = el.getAttribute("uri");
                if (uri.length() > 0) {
                    macrodefName = uri + '#' + macrodefName;
                }
                if (macroDefs.containsKey(macrodefName)) continue;
                macroDefs.put(macrodefName, el);
            }
        }

        private static String replaceMacroParams(String rawval, Map<String, String> defs) {
            if (rawval.indexOf(64) == -1) {
                return rawval;
            }
            int idx = 0;
            StringBuffer val = new StringBuffer();
            while (true) {
                int monkey;
                if ((monkey = rawval.indexOf(64, idx)) == -1 || monkey == rawval.length() - 1) {
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                char c = rawval.charAt(monkey + 1);
                if (c == '{') {
                    int end = rawval.indexOf(125, monkey + 2);
                    if (end != -1) {
                        String otherprop = rawval.substring(monkey + 2, end);
                        if (defs.containsKey(otherprop)) {
                            val.append(rawval.substring(idx, monkey));
                            val.append(defs.get(otherprop));
                        } else {
                            val.append(rawval.substring(idx, end + 1));
                        }
                        idx = end + 1;
                        continue;
                    }
                    val.append(rawval.substring(idx));
                    return val.toString();
                }
                val.append(rawval.substring(idx, idx + 2));
                idx += 2;
            }
        }

        private static String replaceAntProperties(String rawval, Map<String, String> defs) {
            return (String)Script.subst(rawval, defs, Collections.emptySet()).first();
        }

        private static Map<String, String> evaluateAll(Map<String, String> predefs, List<Map<String, String>> defs) {
            HashMap<String, String> m = new HashMap<String, String>(predefs);
            for (Map<String, String> curr : defs) {
                List sorted;
                Map.Entry<String, String> entry2;
                HashMap<String, Object> dependOnSiblings = new HashMap<String, Object>();
                for (Map.Entry<String, String> entry2 : curr.entrySet()) {
                    String prop = entry2.getKey();
                    if (m.containsKey(prop)) continue;
                    String rawval = (String)entry2.getValue();
                    Union2<String, Set<String>> r = Script.subst(rawval, m, curr.keySet());
                    if (r.hasFirst()) {
                        m.put(prop, (String)r.first());
                        continue;
                    }
                    dependOnSiblings.put(prop, r.second());
                }
                HashSet toSort = new HashSet(dependOnSiblings.keySet());
                entry2 = dependOnSiblings.values().iterator();
                while (entry2.hasNext()) {
                    Set sibs = (Set)entry2.next();
                    toSort.addAll(sibs);
                }
                try {
                    sorted = Utilities.topologicalSort(toSort, dependOnSiblings);
                }
                catch (TopologicalSortException e) {
                    return null;
                }
                Collections.reverse(sorted);
                for (String prop : sorted) {
                    if (m.containsKey(prop)) continue;
                    String rawval = curr.get(prop);
                    m.put(prop, (String)Script.subst(rawval, m, curr.keySet()).first());
                }
            }
            return m;
        }

        private static Union2<String, Set<String>> subst(String rawval, Map<String, String> predefs, Set<String> siblingProperties) {
            assert (rawval != null) : "null rawval passed in";
            if (rawval.indexOf(36) == -1) {
                return Union2.createFirst((Object)rawval);
            }
            int idx = 0;
            StringBuffer val = new StringBuffer();
            HashSet<String> needed = new HashSet<String>();
            while (true) {
                int shell;
                if ((shell = rawval.indexOf(36, idx)) == -1 || shell == rawval.length() - 1) {
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx));
                        return Union2.createFirst((Object)val.toString());
                    }
                    return Union2.createSecond(needed);
                }
                char c = rawval.charAt(shell + 1);
                if (c == '$') {
                    if (needed.isEmpty()) {
                        val.append('$');
                    }
                    idx += 2;
                    continue;
                }
                if (c == '{') {
                    int end = rawval.indexOf(125, shell + 2);
                    if (end != -1) {
                        String otherprop = rawval.substring(shell + 2, end);
                        if (predefs.containsKey(otherprop)) {
                            if (needed.isEmpty()) {
                                val.append(rawval.substring(idx, shell));
                                val.append(predefs.get(otherprop));
                            }
                            idx = end + 1;
                            continue;
                        }
                        if (siblingProperties.contains(otherprop)) {
                            needed.add(otherprop);
                            idx = end + 1;
                            continue;
                        }
                        if (needed.isEmpty()) {
                            val.append(rawval.substring(idx, end + 1));
                        }
                        idx = end + 1;
                        continue;
                    }
                    if (needed.isEmpty()) {
                        val.append(rawval.substring(idx));
                        return Union2.createFirst((Object)val.toString());
                    }
                    return Union2.createSecond(needed);
                }
                if (needed.isEmpty()) {
                    val.append(rawval.substring(idx, idx + 2));
                }
                idx += 2;
            }
        }

        public AntProjectCookie getScript() {
            return this.apc;
        }

        public String getName() {
            return this.name;
        }

        public Collection<Target> getTargets() {
            return this.targets.values();
        }

        public String getDefaultTargetName() {
            return this.defaultTarget;
        }

        public Collection<Script> getImports() {
            return this.imports;
        }

        public Script getImportingScript() {
            return this.importingScript;
        }

        public Script getMainScript() {
            if (this.importingScript != null) {
                return this.importingScript.getMainScript();
            }
            return this;
        }

        public boolean defines(String targetName) {
            if (!this.targets.containsKey(targetName)) {
                return false;
            }
            Script s = this.importingScript;
            while (s != null) {
                if (s.targets.containsKey(targetName)) {
                    return false;
                }
                s = s.importingScript;
            }
            return true;
        }

        static {
            TRUE_VALS.add("true");
            TRUE_VALS.add("yes");
            TRUE_VALS.add("on");
        }
    }

    public static final class Target {
        private final Script script;
        private final Element el;
        private final String name;

        Target(Script script, Element el, String name) {
            this.script = script;
            this.el = el;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            String n = this.script.getName();
            if (n != null) {
                return n + '.' + this.getName();
            }
            return this.getName();
        }

        public Element getElement() {
            return this.el;
        }

        public AntProjectCookie getScript() {
            return this.script.getScript();
        }

        public AntProjectCookie getOriginatingScript() {
            return this.script.getMainScript().getScript();
        }

        public boolean isDescribed() {
            return this.el.getAttribute("description").length() > 0;
        }

        public boolean isInternal() {
            String n = this.getName();
            return n.length() > 0 && n.charAt(0) == '-';
        }

        public boolean isOverridden() {
            return !this.script.defines(this.getName());
        }

        public boolean isDefault() {
            return !this.isOverridden() && this.getName().equals(this.script.getMainScript().getDefaultTargetName());
        }

        public String toString() {
            return "Target " + this.getName() + " in " + this.getScript();
        }
    }
}

