/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class JarBuilder {
    public static byte[] classCompiledBytes(String fileName) throws IOException {
        try (InputStream in = JarBuilder.class.getClassLoader().getResourceAsStream(fileName);){
            Objects.requireNonNull(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (in.available() > 0) {
                out.write(in.read());
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void createJarFor(Path pth, Class<?> ... classes) {
        assert (classes.length > 0);
        File file = pth.toFile();
        try {
            try (DynamicType.Unloaded<?> cls = JarBuilder.subclass(classes[0]);){
                cls.toJar(file);
            }
            for (int i = 1; i < classes.length; ++i) {
                try (DynamicType.Unloaded<?> cls = JarBuilder.subclass(classes[i]);){
                    cls.inject(file);
                    continue;
                }
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Could not write %s to %s.".formatted(Arrays.toString(classes), pth), exc);
        }
    }

    private static DynamicType.Unloaded<?> subclass(Class<?> cls) {
        return new ByteBuddy().subclass(cls).method((ElementMatcher)ElementMatchers.isDeclaredBy(cls)).intercept((Implementation)SuperMethodCall.INSTANCE).attribute((MethodAttributeAppender.Factory)MethodAttributeAppender.ForInstrumentedMethod.INCLUDING_RECEIVER).make();
    }
}

