/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;

public class ThreadTestUtils {
    private ThreadTestUtils() {
    }

    public static Thread fork(Runnable runnable) {
        String name = "Forked-from-" + Thread.currentThread().getName();
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static <T> Future<T> forkFuture(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        ThreadTestUtils.fork(task);
        return task;
    }

    public static void awaitThreadState(Thread thread, long maxWaitMillis, Thread.State first, Thread.State ... rest) {
        ThreadTestUtils.awaitThreadState(thread, maxWaitMillis, (StackTraceElement[] s) -> true, first, rest);
    }

    public static void awaitThreadState(Thread thread, long maxWaitMillis, Predicate<StackTraceElement[]> positionFilter, Thread.State first, Thread.State ... rest) {
        Thread.State currentState;
        EnumSet<Thread.State[]> set = EnumSet.of(first, rest);
        long deadline = maxWaitMillis + System.currentTimeMillis();
        do {
            currentState = thread.getState();
            if (System.currentTimeMillis() > deadline) {
                throw new AssertionError((Object)("Timed out waiting for thread state of <" + String.valueOf(set) + ">: " + String.valueOf(thread) + " (state = " + String.valueOf((Object)thread.getState()) + ")"));
            }
        } while (!set.contains((Object)currentState) || !positionFilter.test(thread.getStackTrace()));
    }
}

