/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.actors;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorImpl;

class ActorsManager {
    private final ConcurrentLinkedQueue<ActorImpl> actors = new ConcurrentLinkedQueue();
    private final String managerName;
    private final ThreadGroup threadGroup;

    ActorsManager(String name) {
        this.managerName = name;
        this.threadGroup = new ThreadGroup(this.managerName);
    }

    void stopAllActors() throws InterruptedException {
        ActorImpl actor;
        ArrayList<ActorImpl> stoppedActors = new ArrayList<ActorImpl>();
        while ((actor = this.actors.poll()) != null) {
            actor.stop();
            stoppedActors.add(actor);
        }
        for (ActorImpl stoppedActor : stoppedActors) {
            stoppedActor.join();
        }
    }

    Actor createActor(String name) {
        ActorImpl actor = new ActorImpl(this.threadGroup, "Actor:" + this.managerName + "." + name);
        this.actors.offer(actor);
        return actor;
    }
}

