/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class Race {
    private static final int UNLIMITED = 0;
    private final List<Contestant> contestants = new ArrayList<Contestant>();
    private volatile CountDownLatch readySet;
    private final CountDownLatch go = new CountDownLatch(1);
    private volatile int baseStartDelay;
    private volatile int maxRandomStartDelay;
    private volatile BooleanSupplier endCondition;
    private volatile boolean failure;
    private Consumer<Throwable> failureAction = f -> {};

    public Race withRandomStartDelays() {
        return this.withRandomStartDelays(10, 100);
    }

    public Race withRandomStartDelays(int base, int random) {
        this.baseStartDelay = base;
        this.maxRandomStartDelay = random;
        return this;
    }

    public Race withEndCondition(BooleanSupplier ... endConditions) {
        for (BooleanSupplier endCondition : endConditions) {
            this.endCondition = this.mergeEndCondition(endCondition);
        }
        return this;
    }

    public Race withMaxDuration(long time, TimeUnit unit) {
        long endTimeNano = System.nanoTime() + unit.toNanos(time);
        this.endCondition = this.mergeEndCondition(() -> System.nanoTime() >= endTimeNano);
        return this;
    }

    public Race withFailureAction(Consumer<Throwable> failureAction) {
        this.failureAction = failureAction;
        return this;
    }

    private BooleanSupplier mergeEndCondition(BooleanSupplier additionalEndCondition) {
        BooleanSupplier existingEndCondition = this.endCondition;
        return existingEndCondition == null ? additionalEndCondition : () -> existingEndCondition.getAsBoolean() || additionalEndCondition.getAsBoolean();
    }

    public static Runnable throwing(ThrowingRunnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void addContestants(int count, Runnable contestant) {
        this.addContestants(count, contestant, 0);
    }

    public void addContestants(int count, Runnable contestant, int maxNumberOfRuns) {
        this.addContestants(count, (int i) -> contestant, maxNumberOfRuns);
    }

    public void addContestants(int count, IntFunction<Runnable> contestantSupplier) {
        this.addContestants(count, contestantSupplier, 0);
    }

    public void addContestants(int count, IntFunction<Runnable> contestantSupplier, int maxNumberOfRuns) {
        for (int i = 0; i < count; ++i) {
            this.addContestant(contestantSupplier.apply(i), maxNumberOfRuns);
        }
    }

    public void addContestant(Runnable contestant) {
        this.addContestant(contestant, 0);
    }

    public void addContestant(Runnable contestant, int maxNumberOfRuns) {
        this.contestants.add(new Contestant(contestant, this.contestants.size(), maxNumberOfRuns));
    }

    public void shuffleContestants() {
        Collections.shuffle(this.contestants);
    }

    public Async goAsync() {
        return this.startRace();
    }

    public void go() throws Throwable {
        this.startRace().await(0L, TimeUnit.MILLISECONDS);
    }

    public void go(long maxWaitTime, TimeUnit unit) throws Throwable {
        this.startRace().await(maxWaitTime, unit);
    }

    public void goUnchecked() {
        try {
            this.go();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Async startRace() {
        if (this.endCondition == null) {
            this.endCondition = () -> true;
        }
        this.readySet = new CountDownLatch(this.contestants.size());
        for (Contestant contestant : this.contestants) {
            contestant.start();
        }
        try {
            this.readySet.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Race couldn't start since race was interrupted while awaiting all contestants to start");
        }
        this.go.countDown();
        return (maxWaitTime, unit) -> {
            int errorCount = 0;
            long maxWaitTimeMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
            long waitedSoFar = 0L;
            for (Contestant contestant : this.contestants) {
                if (maxWaitTime == 0L) {
                    contestant.join();
                } else {
                    long timeNanoStart = System.nanoTime();
                    contestant.join(Long.max(1L, maxWaitTimeMillis - waitedSoFar));
                    if ((waitedSoFar += TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - timeNanoStart)) >= maxWaitTimeMillis && contestant.isAlive()) {
                        throw new TimeoutException("Didn't complete after " + maxWaitTime + " " + unit);
                    }
                }
                if (contestant.error == null) continue;
                ++errorCount;
            }
            if (errorCount > 1) {
                Throwable errors = new Throwable("Multiple errors found");
                for (Contestant contestant : this.contestants) {
                    if (contestant.error == null) continue;
                    errors.addSuppressed(contestant.error);
                }
                throw errors;
            }
            if (errorCount == 1) {
                for (Contestant contestant : this.contestants) {
                    if (contestant.error == null) continue;
                    throw contestant.error;
                }
            }
        };
    }

    public boolean hasFailed() {
        return this.failure;
    }

    public static interface Async {
        public void await(long var1, TimeUnit var3) throws Throwable;
    }

    private class Contestant
    extends Thread {
        private volatile Throwable error;
        private final int maxNumberOfRuns;
        private int runs;

        Contestant(Runnable code, int nr, int maxNumberOfRuns) {
            super(code, "Contestant#" + nr);
            this.maxNumberOfRuns = maxNumberOfRuns;
            this.setUncaughtExceptionHandler((thread, error) -> {});
        }

        @Override
        public void run() {
            Race.this.readySet.countDown();
            try {
                Race.this.go.await();
            }
            catch (InterruptedException e) {
                this.error = e;
                this.interrupt();
                return;
            }
            if (Race.this.baseStartDelay > 0 || Race.this.maxRandomStartDelay > 0) {
                this.randomlyDelaySlightly();
            }
            try {
                while (!Race.this.failure) {
                    super.run();
                    if ((this.maxNumberOfRuns == 0 || ++this.runs != this.maxNumberOfRuns) && !Race.this.endCondition.getAsBoolean()) continue;
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.error = e;
                Race.this.failure = true;
                Race.this.failureAction.accept(e);
                throw e;
            }
        }

        private void randomlyDelaySlightly() {
            int millis = ThreadLocalRandom.current().nextInt(Race.this.maxRandomStartDelay);
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(Race.this.baseStartDelay + millis));
        }
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

