/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.test.OtherThreadExecutor;

public class OtherThreadRule
implements TestRule {
    private String name;
    private long timeout;
    private TimeUnit unit;
    private volatile OtherThreadExecutor executor;

    public OtherThreadRule() {
        this(null);
    }

    public OtherThreadRule(String name) {
        this.set(name, 60L, TimeUnit.SECONDS);
    }

    public OtherThreadRule(long timeout, TimeUnit unit) {
        this.set(null, timeout, unit);
    }

    public void set(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public void set(String name, long timeout, TimeUnit unit) {
        this.name = name;
        this.timeout = timeout;
        this.unit = unit;
    }

    public <RESULT> Future<RESULT> execute(Callable<RESULT> cmd) {
        Future<RESULT> future = this.executor.executeDontWait(cmd);
        try {
            this.executor.awaitStartExecuting();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while awaiting start of execution.", e);
        }
        return future;
    }

    public OtherThreadExecutor get() {
        return this.executor;
    }

    public void interrupt() {
        this.executor.interrupt();
    }

    public String toString() {
        OtherThreadExecutor otherThread = this.executor;
        if (otherThread == null) {
            return "OtherThreadRule[state=dead]";
        }
        return otherThread.toString();
    }

    public void beforeEach(ExtensionContext context) {
        String displayName = context.getDisplayName();
        String threadName = this.name != null ? this.name + "-" + displayName : displayName;
        this.init(threadName);
    }

    public void afterEach() {
        try {
            this.executor.close();
        }
        finally {
            this.executor = null;
        }
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String threadName = OtherThreadRule.this.name != null ? OtherThreadRule.this.name + "-" + description.getDisplayName() : description.getDisplayName();
                OtherThreadRule.this.init(threadName);
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        OtherThreadRule.this.executor.close();
                    }
                    finally {
                        OtherThreadRule.this.executor = null;
                    }
                }
            }
        };
    }

    public void init(String threadName) {
        this.executor = new OtherThreadExecutor(threadName, this.timeout, this.unit);
    }

    public void close() {
        this.executor.close();
    }
}

