/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.reflect.Field;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.extension.Inject;

public abstract class StatefullFieldExtension<T>
implements TestInstancePostProcessor,
AfterAllCallback {
    protected abstract String getFieldKey();

    protected abstract Class<T> getFieldType();

    protected abstract T createField(ExtensionContext var1);

    protected abstract ExtensionContext.Namespace getNameSpace();

    public void afterAll(ExtensionContext context) throws Exception {
        this.removeStoredValue(context);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Class<?> clazz = testInstance.getClass();
        Object instance = this.createInstance(context);
        List<Field> declaredFields = ReflectionUtil.getAllFields(clazz);
        for (Field declaredField : declaredFields) {
            if (!declaredField.isAnnotationPresent(Inject.class) || !declaredField.getType().isAssignableFrom(this.getFieldType())) continue;
            declaredField.setAccessible(true);
            if (declaredField.get(testInstance) != null) {
                throw new ExtensionConfigurationException(String.format("Field %s that is marked for injection in class %s is managed by extension container and should not have any manually assigned value.", declaredField.getName(), clazz.getName()));
            }
            declaredField.set(testInstance, instance);
        }
    }

    protected T getStoredValue(ExtensionContext context) {
        return (T)this.getLocalStore(context).get((Object)this.getFieldKey(), this.getFieldType());
    }

    protected T removeStoredValue(ExtensionContext context) {
        return (T)this.getLocalStore(context).remove((Object)this.getFieldKey(), this.getFieldType());
    }

    protected T deepRemoveStoredValue(ExtensionContext context) {
        T removedValue = null;
        ExtensionContext valueContext = context;
        while (removedValue == null && valueContext != null) {
            removedValue = this.removeStoredValue(valueContext);
            valueContext = valueContext.getParent().orElse(null);
        }
        return removedValue;
    }

    protected static ExtensionContext.Store getStore(ExtensionContext extensionContext, ExtensionContext.Namespace namespace) {
        return extensionContext.getStore(namespace);
    }

    private ExtensionContext.Store getLocalStore(ExtensionContext extensionContext) {
        return StatefullFieldExtension.getStore(extensionContext, this.getNameSpace());
    }

    private Object createInstance(ExtensionContext extensionContext) {
        T value = this.getStoredValue(extensionContext);
        if (value == null) {
            value = this.createField(extensionContext);
            this.getLocalStore(extensionContext).put((Object)this.getFieldKey(), value);
        }
        return value;
    }
}

