/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class ThrowableWithMessageMatcher
extends TypeSafeMatcher<Throwable> {
    private final Class<? extends Throwable> expectedType;
    private final Matcher<String> messageMatcher;

    ThrowableWithMessageMatcher(Class<? extends Throwable> expectedType, Matcher<String> messageMatcher) {
        this.expectedType = expectedType;
        this.messageMatcher = messageMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("throwable of type ").appendValue(this.expectedType).appendText(" with message ").appendDescriptionOf(this.messageMatcher);
    }

    protected boolean matchesSafely(Throwable item) {
        return this.expectedType.isInstance(item) && this.messageMatcher.matches((Object)item.getMessage());
    }
}

