/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.guard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.neo4j.test.extension.guard.DependenciesCollector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JUnitUsageGuardExtension
implements BeforeAllCallback {
    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClazz = context.getRequiredTestClass();
        Set<String> testClasses = JUnitUsageGuardExtension.collectUsedTestClasses(testClazz);
        testClasses.removeIf(s -> s.startsWith("org.junit.platform"));
        testClasses.removeIf(s -> s.startsWith("org.junit.runners.model"));
        Set<String> newJunitClasses = testClasses.stream().filter(s -> s.startsWith("org.junit.jupiter")).collect(Collectors.toSet());
        if (newJunitClasses.isEmpty() || JUnitUsageGuardExtension.noOldJunitUsages(testClasses, newJunitClasses)) {
            return;
        }
        testClasses.removeAll(newJunitClasses);
        throw new JUnitException(String.format("Detect usage of classes from multiple junit versions in the single test class: %s.%nDetected JUnit 5 classes: %s.%nDetected Junit 4 classes: %s.", testClazz.getName(), JUnitUsageGuardExtension.sortedClasses(newJunitClasses), JUnitUsageGuardExtension.sortedClasses(testClasses)));
    }

    private static List<String> sortedClasses(Set<String> newJunitClasses) {
        ArrayList<String> strings = new ArrayList<String>(newJunitClasses);
        Collections.sort(strings);
        return strings;
    }

    private static boolean noOldJunitUsages(Set<String> testClasses, Set<String> newJunitClasses) {
        return newJunitClasses.size() == testClasses.size();
    }

    private static Set<String> collectUsedTestClasses(Class<?> clazz) throws IOException {
        ClassReader classReader = new ClassReader(clazz.getName());
        DependenciesCollector dependenciesCollector = new DependenciesCollector();
        classReader.accept((ClassVisitor)dependenciesCollector, 0);
        return dependenciesCollector.getJunitTestClasses();
    }
}

