/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ssl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.neo4j.test.ssl.InsecureRandom;

public class SelfSignedCertificateFactory {
    private static final boolean useInsecureCertificateGeneration = Boolean.getBoolean("org.neo4j.useInsecureCertificateGeneration");
    private static final String DEFAULT_ENCRYPTION = "RSA";
    private final SecureRandom random = useInsecureCertificateGeneration ? new InsecureRandom() : new SecureRandom();
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(253402300799000L);
    private static final Provider PROVIDER = new BouncyCastleProvider();
    private static final String DEFAULT_KEY_FILE_NAME = "private.key";
    private static final String DEFAULT_CERT_FILE_NAME = "public.crt";
    private static final String DEFAULT_HOST_NAME = "localhost";
    private static volatile boolean cleanupRequired = true;

    public static void create(File certDir) {
        SelfSignedCertificateFactory.create(certDir, DEFAULT_KEY_FILE_NAME, DEFAULT_CERT_FILE_NAME);
    }

    public static void create(File certDir, String keyFileName, String certFileName) {
        SelfSignedCertificateFactory certificateFactory = new SelfSignedCertificateFactory();
        File privateKeyFile = new File(certDir, keyFileName);
        File certificateFile = new File(certDir, certFileName);
        if (!privateKeyFile.exists() && !certificateFile.exists()) {
            try {
                certificateFactory.createSelfSignedCertificate(certificateFile, privateKeyFile, DEFAULT_HOST_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate private key and certificate", e);
            }
        }
    }

    public void createSelfSignedCertificate(File certificatePath, File privateKeyPath, String hostName) throws GeneralSecurityException, IOException, OperatorCreationException {
        SelfSignedCertificateFactory.installCleanupHook(certificatePath, privateKeyPath);
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(DEFAULT_ENCRYPTION);
        keyGen.initialize(2048, this.random);
        KeyPair keypair = keyGen.generateKeyPair();
        X500Name owner = new X500Name("CN=" + hostName);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, this.random), NOT_BEFORE, NOT_AFTER, owner, keypair.getPublic());
        GeneralNames subjectAlternativeName = new GeneralNames(new GeneralName(2, hostName));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeName);
        PrivateKey privateKey = keypair.getPrivate();
        ContentSigner signer = new JcaContentSignerBuilder("SHA512WithRSAEncryption").build(privateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        this.writePem("CERTIFICATE", cert.getEncoded(), certificatePath);
        this.writePem("PRIVATE KEY", privateKey.getEncoded(), privateKeyPath);
        cleanupRequired = false;
    }

    private static void installCleanupHook(File certificatePath, File privateKeyPath) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (cleanupRequired) {
                System.err.println("Cleaning up partially generated self-signed certificate...");
                if (certificatePath.exists()) {
                    certificatePath.delete();
                }
                if (privateKeyPath.exists()) {
                    privateKeyPath.delete();
                }
            }
        }));
    }

    private void writePem(String type, byte[] encodedContent, File path) throws IOException {
        path.getParentFile().mkdirs();
        try (PemWriter writer = new PemWriter((Writer)new FileWriter(path));){
            writer.writeObject((PemObjectGenerator)new PemObject(type, encodedContent));
            writer.flush();
        }
        path.setReadable(false, false);
        path.setWritable(false, false);
        path.setReadable(true);
        path.setWritable(true);
    }

    static {
        Security.addProvider(PROVIDER);
    }
}

