/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public final class SuppressOutput {
    private static final Suppressible java_util_logging = SuppressOutput.java_util_logging(new ByteArrayOutputStream(), null);
    private final Suppressible[] suppressibles;
    private Voice[] voices;

    public static SuppressOutput suppress(Suppressible ... suppressibles) {
        return new SuppressOutput(suppressibles);
    }

    public static SuppressOutput suppressAll() {
        return SuppressOutput.suppress(System.out, System.err, java_util_logging);
    }

    private static Suppressible java_util_logging(final ByteArrayOutputStream redirectTo, Level level) {
        StreamHandler replacement;
        StreamHandler streamHandler = replacement = redirectTo == null ? null : new StreamHandler(redirectTo, new SimpleFormatter());
        if (replacement != null && level != null) {
            replacement.setLevel(level);
        }
        return new Suppressible(){

            @Override
            public Voice suppress() {
                Handler[] handlers;
                final Logger logger = LogManager.getLogManager().getLogger("");
                final Level level = logger.getLevel();
                for (Handler handler : handlers = logger.getHandlers()) {
                    logger.removeHandler(handler);
                }
                if (replacement != null) {
                    logger.addHandler(replacement);
                    logger.setLevel(Level.ALL);
                }
                return new Voice(this, redirectTo){

                    @Override
                    void restore(boolean failure) {
                        for (Handler handler : handlers) {
                            logger.addHandler(handler);
                        }
                        logger.setLevel(level);
                        if (replacement != null) {
                            logger.removeHandler(replacement);
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> callable) throws Exception {
        this.captureVoices();
        boolean failure = true;
        try {
            T result = callable.call();
            failure = false;
            T t = result;
            return t;
        }
        finally {
            SuppressOutput.releaseVoices(this.voices, failure);
        }
    }

    private SuppressOutput(Suppressible[] suppressibles) {
        this.suppressibles = suppressibles;
    }

    public Voice[] getAllVoices() {
        return this.voices;
    }

    public Voice getOutputVoice() {
        return this.getVoice(System.out);
    }

    public Voice getErrorVoice() {
        return this.getVoice(System.err);
    }

    private Voice getVoice(Suppressible suppressible) {
        for (Voice voice : this.voices) {
            if (!suppressible.equals(voice.getSuppressible())) continue;
            return voice;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureVoices() {
        Voice[] voices = new Voice[this.suppressibles.length];
        boolean ok = false;
        try {
            for (int i = 0; i < voices.length; ++i) {
                voices[i] = this.suppressibles[i].suppress();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                SuppressOutput.releaseVoices(voices, false);
            }
        }
        this.voices = voices;
    }

    public void releaseVoices(boolean failure) {
        SuppressOutput.releaseVoices(this.voices, failure);
    }

    private static void releaseVoices(Voice[] voices, boolean failure) {
        ArrayList<Throwable> failures = null;
        try {
            failures = new ArrayList<Throwable>(voices.length);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Voice voice : voices) {
            if (voice == null) continue;
            try {
                voice.restore(failure);
            }
            catch (Throwable exception) {
                if (failures == null) continue;
                failures.add(exception);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            for (Throwable exception : failures) {
                exception.printStackTrace();
            }
        }
    }

    public static interface Suppressible {
        public Voice suppress();
    }

    public static enum System implements Suppressible
    {
        out{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.out;
                java.lang.System.setOut(replacement);
                return old;
            }
        }
        ,
        err{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.err;
                java.lang.System.setErr(replacement);
                return old;
            }
        };


        @Override
        public Voice suppress() {
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            final PrintStream original = this.replace(new PrintStream(buffer));
            return new Voice(this, buffer, original){

                @Override
                void restore(boolean failure) throws IOException {
                    this.replace(original).flush();
                    if (failure) {
                        buffer.writeTo(original);
                    }
                }
            };
        }

        abstract PrintStream replace(PrintStream var1);
    }

    public static abstract class Voice {
        private final Suppressible suppressible;
        private final ByteArrayOutputStream replacementBuffer;
        private final PrintStream original;

        public Voice(Suppressible suppressible, ByteArrayOutputStream replacementBuffer) {
            this(suppressible, replacementBuffer, null);
        }

        public Voice(Suppressible suppressible, ByteArrayOutputStream replacementBuffer, PrintStream original) {
            this.suppressible = suppressible;
            this.replacementBuffer = replacementBuffer;
            this.original = original;
        }

        Suppressible getSuppressible() {
            return this.suppressible;
        }

        public boolean containsMessage(String message) {
            return this.replacementBuffer.toString().contains(message);
        }

        public List<String> lines() {
            return Arrays.asList(this.toString().split(java.lang.System.lineSeparator()));
        }

        public boolean isEmpty() {
            return this.replacementBuffer.size() == 0;
        }

        public String toString() {
            return this.replacementBuffer.toString(StandardCharsets.UTF_8);
        }

        abstract void restore(boolean var1) throws IOException;

        public Optional<PrintStream> originalStream() {
            return Optional.ofNullable(this.original);
        }
    }
}

