/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.neo4j.test.extension.Inject;

public class TestInstanceValidationExtension
implements BeforeTestExecutionCallback {
    public void beforeTestExecution(ExtensionContext context) {
        Optional testInstance = context.getTestInstance();
        testInstance.ifPresent(instance -> {
            Class<?> instanceClass = instance.getClass();
            List annotatedFields = AnnotationSupport.findAnnotatedFields(instanceClass, Inject.class);
            for (Field annotatedField : annotatedFields) {
                Optional fieldValue = ReflectionUtils.tryToReadFieldValue((Field)annotatedField, (Object)instance).toOptional();
                if (!fieldValue.isEmpty()) continue;
                throw new ExtensionConfigurationException(String.format("Field %s that is marked for injection in class %s is null. Please check that you have configured all desired extensions or double check fields that should be injected.", annotatedField.getName(), instanceClass.getName()));
            }
        });
    }
}

