/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.actors;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsManager;

public class ActorsSupportExtension
implements TestInstancePostProcessor,
AfterEachCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"neo4j", "actors"});
    private static final String ACTOR_MANAGER = "ACTOR_MANAGER";

    public void afterAll(ExtensionContext context) throws Exception {
        if (ActorsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_CLASS) {
            ActorsSupportExtension.tearDownActors(context);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (ActorsSupportExtension.getLifecycle(context) == TestInstance.Lifecycle.PER_METHOD) {
            ActorsSupportExtension.tearDownActors(context);
        }
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }

    private static void tearDownActors(ExtensionContext context) throws Exception {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            ExtensionContext ctx = current.get();
            ActorsManager manager = (ActorsManager)ActorsSupportExtension.getStore(ctx).remove((Object)ACTOR_MANAGER);
            if (manager != null) {
                manager.stopAllActors();
            }
            current = ctx.getParent();
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        Field[] declaredFields;
        ActorsManager manager = (ActorsManager)ActorsSupportExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)ACTOR_MANAGER, k -> new ActorsManager(extensionContext.getDisplayName()));
        Class<?> clazz = testInstance.getClass();
        for (Field declaredField : declaredFields = FieldUtils.getAllFields(clazz)) {
            if (declaredField.getType() != Actor.class || !declaredField.isAnnotationPresent(Inject.class)) continue;
            if (Modifier.isStatic(declaredField.getModifiers())) {
                throw new ExtensionConfigurationException(String.format("Actors cannot be inject into static field: %s.%s.", clazz.getName(), declaredField.getName()));
            }
            declaredField.setAccessible(true);
            if (declaredField.get(testInstance) != null) {
                throw new ExtensionConfigurationException(String.format("Field %s that is marked for injection in class %s is managed by extension container and should not have any manually assigned value.", declaredField.getName(), clazz.getName()));
            }
            declaredField.set(testInstance, manager.createActor(declaredField.getName()));
        }
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(NAMESPACE);
    }
}

