/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.ArrayIterator;

public abstract class PropertyTypeDispatcher<K, T> {
    public static void consumeProperties(PropertyTypeDispatcher<String, Void> dispatcher, PropertyContainer entity) {
        for (String key : entity.getPropertyKeys()) {
            Object property = entity.getProperty(key, null);
            if (property == null) continue;
            dispatcher.dispatch(property, key);
        }
    }

    public static <T> Collection<T> dispatchProperties(PropertyTypeDispatcher<String, T> dispatcher, PropertyContainer entity) {
        ArrayList<T> result = new ArrayList<T>();
        for (String key : entity.getPropertyKeys()) {
            Object property = entity.getProperty(key, null);
            if (property == null) continue;
            result.add(dispatcher.dispatch(property, key));
        }
        return result;
    }

    public final T dispatch(Object property, K param) {
        if (property == null) {
            return this.dispatchNullProperty(param);
        }
        if (property instanceof String) {
            return this.dispatchStringProperty((String)property, param);
        }
        if (property instanceof Number) {
            return this.dispatchNumberProperty((Number)property, param);
        }
        if (property instanceof Boolean) {
            return this.dispatchBooleanProperty((Boolean)property, param);
        }
        if (property instanceof Character) {
            return this.dispatchCharacterProperty(((Character)property).charValue(), param);
        }
        if (property instanceof String[]) {
            return this.dispatchStringArrayProperty((String[])property, param);
        }
        if (property instanceof Object[]) {
            return this.dispatchOtherArray((Object[])property, param);
        }
        Class<?> propertyType = property.getClass();
        if (propertyType.isArray() && propertyType.getComponentType().isPrimitive()) {
            return this.dispatchPrimitiveArray(property, param);
        }
        return this.dispatchOtherProperty(property, param);
    }

    private T dispatchPrimitiveArray(Object property, K param) {
        if (property instanceof byte[]) {
            return this.dispatchByteArrayProperty((byte[])property, param);
        }
        if (property instanceof char[]) {
            return this.dispatchCharacterArrayProperty((char[])property, param);
        }
        if (property instanceof boolean[]) {
            return this.dispatchBooleanArrayProperty((boolean[])property, param);
        }
        if (property instanceof long[]) {
            return this.dispatchLongArrayProperty((long[])property, param);
        }
        if (property instanceof double[]) {
            return this.dispatchDoubleArrayProperty((double[])property, param);
        }
        if (property instanceof int[]) {
            return this.dispatchIntegerArrayProperty((int[])property, param);
        }
        if (property instanceof short[]) {
            return this.dispatchShortArrayProperty((short[])property, param);
        }
        if (property instanceof float[]) {
            return this.dispatchFloatArrayProperty((float[])property, param);
        }
        throw new Error("Unsupported primitive array type: " + property.getClass());
    }

    protected T dispatchOtherArray(Object[] property, K param) {
        if (property instanceof Byte[]) {
            return this.dispatchByteArrayProperty((Byte[])property, param);
        }
        if (property instanceof Character[]) {
            return this.dispatchCharacterArrayProperty((Character[])property, param);
        }
        if (property instanceof Boolean[]) {
            return this.dispatchBooleanArrayProperty((Boolean[])property, param);
        }
        if (property instanceof Long[]) {
            return this.dispatchLongArrayProperty((Long[])property, param);
        }
        if (property instanceof Double[]) {
            return this.dispatchDoubleArrayProperty((Double[])property, param);
        }
        if (property instanceof Integer[]) {
            return this.dispatchIntegerArrayProperty((Integer[])property, param);
        }
        if (property instanceof Short[]) {
            return this.dispatchShortArrayProperty((Short[])property, param);
        }
        if (property instanceof Float[]) {
            return this.dispatchFloatArrayProperty((Float[])property, param);
        }
        throw new IllegalArgumentException("Unsupported property array type: " + property.getClass());
    }

    protected T dispatchNumberProperty(Number property, K param) {
        if (property instanceof Long) {
            return this.dispatchLongProperty((Long)property, param);
        }
        if (property instanceof Integer) {
            return this.dispatchIntegerProperty((Integer)property, param);
        }
        if (property instanceof Double) {
            return this.dispatchDoubleProperty((Double)property, param);
        }
        if (property instanceof Float) {
            return this.dispatchFloatProperty(((Float)property).floatValue(), param);
        }
        if (property instanceof Short) {
            return this.dispatchShortProperty((Short)property, param);
        }
        if (property instanceof Byte) {
            return this.dispatchByteProperty((Byte)property, param);
        }
        throw new IllegalArgumentException("Unsupported property type: " + property.getClass());
    }

    protected T dispatchNullProperty(K param) {
        return null;
    }

    protected abstract T dispatchByteProperty(byte var1, K var2);

    protected abstract T dispatchCharacterProperty(char var1, K var2);

    protected abstract T dispatchShortProperty(short var1, K var2);

    protected abstract T dispatchIntegerProperty(int var1, K var2);

    protected abstract T dispatchLongProperty(long var1, K var3);

    protected abstract T dispatchFloatProperty(float var1, K var2);

    protected abstract T dispatchDoubleProperty(double var1, K var3);

    protected abstract T dispatchBooleanProperty(boolean var1, K var2);

    protected T dispatchOtherProperty(Object property, K param) {
        throw new IllegalArgumentException("Unsupported property array type: " + property.getClass());
    }

    protected T dispatchByteArrayProperty(final byte[] property, K param) {
        return this.dispatchByteArrayProperty((PropertyArray<byte[], Byte>)new PrimitiveArray<byte[], Byte>(){

            @Override
            public byte[] getClonedArray() {
                return (byte[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Byte item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchCharacterArrayProperty(final char[] property, K param) {
        return this.dispatchCharacterArrayProperty((PropertyArray<char[], Character>)new PrimitiveArray<char[], Character>(){

            @Override
            public char[] getClonedArray() {
                return (char[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Character item(int offset) {
                return Character.valueOf(property[offset]);
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchShortArrayProperty(final short[] property, K param) {
        return this.dispatchShortArrayProperty((PropertyArray<short[], Short>)new PrimitiveArray<short[], Short>(){

            @Override
            public short[] getClonedArray() {
                return (short[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Short item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchIntegerArrayProperty(final int[] property, K param) {
        return this.dispatchIntegerArrayProperty((PropertyArray<int[], Integer>)new PrimitiveArray<int[], Integer>(){

            @Override
            public int[] getClonedArray() {
                return (int[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Integer item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchLongArrayProperty(final long[] property, K param) {
        return this.dispatchLongArrayProperty((PropertyArray<long[], Long>)new PrimitiveArray<long[], Long>(){

            @Override
            public long[] getClonedArray() {
                return (long[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Long item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchFloatArrayProperty(final float[] property, K param) {
        return this.dispatchFloatArrayProperty((PropertyArray<float[], Float>)new PrimitiveArray<float[], Float>(){

            @Override
            public float[] getClonedArray() {
                return (float[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Float item(int offset) {
                return Float.valueOf(property[offset]);
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchDoubleArrayProperty(final double[] property, K param) {
        return this.dispatchDoubleArrayProperty((PropertyArray<double[], Double>)new PrimitiveArray<double[], Double>(){

            @Override
            public double[] getClonedArray() {
                return (double[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Double item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchBooleanArrayProperty(final boolean[] property, K param) {
        return this.dispatchBooleanArrayProperty((PropertyArray<boolean[], Boolean>)new PrimitiveArray<boolean[], Boolean>(){

            @Override
            public boolean[] getClonedArray() {
                return (boolean[])property.clone();
            }

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Boolean item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    protected T dispatchByteArrayProperty(final Byte[] property, K param) {
        return this.dispatchByteArrayProperty((PropertyArray<byte[], Byte>)new BoxedArray<byte[], Byte>(property){

            @Override
            public byte[] getClonedArray() {
                byte[] result = new byte[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected T dispatchCharacterArrayProperty(final Character[] property, K param) {
        return this.dispatchCharacterArrayProperty((PropertyArray<char[], Character>)new BoxedArray<char[], Character>(property){

            @Override
            public char[] getClonedArray() {
                char[] result = new char[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i].charValue();
                }
                return result;
            }
        }, param);
    }

    protected T dispatchShortArrayProperty(final Short[] property, K param) {
        return this.dispatchShortArrayProperty((PropertyArray<short[], Short>)new BoxedArray<short[], Short>(property){

            @Override
            public short[] getClonedArray() {
                short[] result = new short[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected T dispatchIntegerArrayProperty(final Integer[] property, K param) {
        return this.dispatchIntegerArrayProperty((PropertyArray<int[], Integer>)new BoxedArray<int[], Integer>(property){

            @Override
            public int[] getClonedArray() {
                int[] result = new int[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected T dispatchLongArrayProperty(final Long[] property, K param) {
        return this.dispatchLongArrayProperty((PropertyArray<long[], Long>)new BoxedArray<long[], Long>(property){

            @Override
            public long[] getClonedArray() {
                long[] result = new long[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected T dispatchFloatArrayProperty(final Float[] property, K param) {
        return this.dispatchFloatArrayProperty((PropertyArray<float[], Float>)new BoxedArray<float[], Float>(property){

            @Override
            public float[] getClonedArray() {
                float[] result = new float[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i].floatValue();
                }
                return result;
            }
        }, param);
    }

    protected T dispatchDoubleArrayProperty(final Double[] property, K param) {
        return this.dispatchDoubleArrayProperty((PropertyArray<double[], Double>)new BoxedArray<double[], Double>(property){

            @Override
            public double[] getClonedArray() {
                double[] result = new double[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected T dispatchBooleanArrayProperty(final Boolean[] property, K param) {
        return this.dispatchBooleanArrayProperty((PropertyArray<boolean[], Boolean>)new BoxedArray<boolean[], Boolean>(property){

            @Override
            public boolean[] getClonedArray() {
                boolean[] result = new boolean[property.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = property[i];
                }
                return result;
            }
        }, param);
    }

    protected abstract T dispatchStringProperty(String var1, K var2);

    protected T dispatchStringArrayProperty(final String[] property, K param) {
        return this.dispatchStringArrayProperty((PropertyArray<String[], String>)new BoxedArray<String[], String>(property){

            @Override
            public String[] getClonedArray() {
                return (String[])property.clone();
            }
        }, param);
    }

    protected T dispatchStringArrayProperty(PropertyArray<String[], String> array, K param) {
        return this.dispatchArray(array, param);
    }

    protected T dispatchByteArrayProperty(PropertyArray<byte[], Byte> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchCharacterArrayProperty(PropertyArray<char[], Character> array, K param) {
        return this.dispatchArray(array, param);
    }

    protected T dispatchShortArrayProperty(PropertyArray<short[], Short> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchIntegerArrayProperty(PropertyArray<int[], Integer> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchLongArrayProperty(PropertyArray<long[], Long> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchFloatArrayProperty(PropertyArray<float[], Float> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchDoubleArrayProperty(PropertyArray<double[], Double> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchBooleanArrayProperty(PropertyArray<boolean[], Boolean> array, K param) {
        return this.dispatchArray(array, param);
    }

    protected T dispatchNumberArray(PropertyArray<?, ? extends Number> array, K param) {
        return this.dispatchArray(array, param);
    }

    protected T dispatchArray(PropertyArray<?, ?> array, K param) {
        throw new UnsupportedOperationException("Unhandled array type: " + array.getType());
    }

    private static abstract class PrimitiveArray<A, T>
    extends PropertyArray<A, T> {
        private PrimitiveArray() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                final int size;
                int pos;
                {
                    this.size = PrimitiveArray.this.length();
                    this.pos = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size;
                }

                @Override
                public T next() {
                    return PrimitiveArray.this.item(this.pos++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove element from primitive array.");
                }
            };
        }

        protected abstract T item(int var1);
    }

    private static abstract class BoxedArray<A, T>
    extends PropertyArray<A, T> {
        private final T[] array;

        BoxedArray(T[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator((Object[])this.array);
        }

        @Override
        public Class<?> getType() {
            return this.array.getClass();
        }
    }

    public static abstract class PropertyArray<A, T>
    implements Iterable<T> {
        private PropertyArray() {
        }

        public abstract int length();

        public abstract A getClonedArray();

        public abstract Class<?> getType();
    }
}

