/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.net.URI;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.helpers.PropertyTypeDispatcher;
import org.neo4j.server.rest.repr.ExtensionInjector;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.ListSerializer;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.Serializer;

public class ValueRepresentation
extends Representation {
    private final Object value;
    private static final PropertyTypeDispatcher<Void, Representation> PROPERTY_REPRESENTATION = new PropertyTypeDispatcher<Void, Representation>(){

        @Override
        protected Representation dispatchBooleanProperty(boolean property, Void param) {
            return ValueRepresentation.bool(property);
        }

        @Override
        protected Representation dispatchByteProperty(byte property, Void param) {
            return new ValueRepresentation(RepresentationType.BYTE, property);
        }

        @Override
        protected Representation dispatchCharacterProperty(char property, Void param) {
            return new ValueRepresentation(RepresentationType.CHAR, Character.valueOf(property));
        }

        @Override
        protected Representation dispatchDoubleProperty(double property, Void param) {
            return new ValueRepresentation(RepresentationType.DOUBLE, property);
        }

        @Override
        protected Representation dispatchFloatProperty(float property, Void param) {
            return new ValueRepresentation(RepresentationType.FLOAT, Float.valueOf(property));
        }

        @Override
        protected Representation dispatchIntegerProperty(int property, Void param) {
            return new ValueRepresentation(RepresentationType.INTEGER, property);
        }

        @Override
        protected Representation dispatchLongProperty(long property, Void param) {
            return new ValueRepresentation(RepresentationType.LONG, property);
        }

        @Override
        protected Representation dispatchShortProperty(short property, Void param) {
            return new ValueRepresentation(RepresentationType.SHORT, property);
        }

        @Override
        protected Representation dispatchStringProperty(String property, Void param) {
            return ValueRepresentation.string(property);
        }

        @Override
        protected Representation dispatchStringArrayProperty(String[] property, Void param) {
            return ListRepresentation.strings(property);
        }

        private Iterable<Representation> dispatch(PropertyTypeDispatcher.PropertyArray<?, ?> array) {
            return new IterableWrapper<Representation, Object>(array){

                protected Representation underlyingObjectToObject(Object object) {
                    return ValueRepresentation.property(object);
                }
            };
        }

        @Override
        protected Representation dispatchByteArrayProperty(PropertyTypeDispatcher.PropertyArray<byte[], Byte> array, Void param) {
            return new ListRepresentation(RepresentationType.BYTE, this.dispatch(array));
        }

        @Override
        protected Representation dispatchShortArrayProperty(PropertyTypeDispatcher.PropertyArray<short[], Short> array, Void param) {
            return new ListRepresentation(RepresentationType.SHORT, this.dispatch(array));
        }

        @Override
        protected Representation dispatchCharacterArrayProperty(PropertyTypeDispatcher.PropertyArray<char[], Character> array, Void param) {
            return new ListRepresentation(RepresentationType.CHAR, this.dispatch(array));
        }

        @Override
        protected Representation dispatchIntegerArrayProperty(PropertyTypeDispatcher.PropertyArray<int[], Integer> array, Void param) {
            return new ListRepresentation(RepresentationType.INTEGER, this.dispatch(array));
        }

        @Override
        protected Representation dispatchLongArrayProperty(PropertyTypeDispatcher.PropertyArray<long[], Long> array, Void param) {
            return new ListRepresentation(RepresentationType.LONG, this.dispatch(array));
        }

        @Override
        protected Representation dispatchFloatArrayProperty(PropertyTypeDispatcher.PropertyArray<float[], Float> array, Void param) {
            return new ListRepresentation(RepresentationType.FLOAT, this.dispatch(array));
        }

        @Override
        protected Representation dispatchDoubleArrayProperty(PropertyTypeDispatcher.PropertyArray<double[], Double> array, Void param) {
            return new ListRepresentation(RepresentationType.DOUBLE, this.dispatch(array));
        }

        @Override
        protected Representation dispatchBooleanArrayProperty(PropertyTypeDispatcher.PropertyArray<boolean[], Boolean> array, Void param) {
            return new ListRepresentation(RepresentationType.BOOLEAN, this.dispatch(array));
        }
    };

    private ValueRepresentation(RepresentationType type, Object value) {
        super(type);
        this.value = value;
    }

    @Override
    String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
        return format.serializeValue(this.type, this.value);
    }

    @Override
    void addTo(ListSerializer serializer) {
        serializer.writer.writeValue(this.type, this.value);
    }

    @Override
    void putTo(MappingSerializer serializer, String key) {
        serializer.writer.writeValue(this.type, key, this.value);
    }

    public static ValueRepresentation string(String value) {
        return new ValueRepresentation(RepresentationType.STRING, value);
    }

    public static ValueRepresentation number(int value) {
        return new ValueRepresentation(RepresentationType.INTEGER, value);
    }

    public static ValueRepresentation number(long value) {
        return new ValueRepresentation(RepresentationType.LONG, value);
    }

    public static ValueRepresentation number(double value) {
        return new ValueRepresentation(RepresentationType.DOUBLE, value);
    }

    public static ValueRepresentation bool(boolean value) {
        return new ValueRepresentation(RepresentationType.BOOLEAN, value);
    }

    public static ValueRepresentation relationshipType(RelationshipType type) {
        return new ValueRepresentation(RepresentationType.RELATIONSHIP_TYPE, type.name());
    }

    public static ValueRepresentation uri(final String path) {
        return new ValueRepresentation(RepresentationType.URI, null){

            @Override
            String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
                return Serializer.joinBaseWithRelativePath(baseUri, path);
            }

            @Override
            void addTo(ListSerializer serializer) {
                serializer.addUri(path);
            }

            @Override
            void putTo(MappingSerializer serializer, String key) {
                serializer.putUri(key, path);
            }
        };
    }

    public static ValueRepresentation template(final String path) {
        return new ValueRepresentation(RepresentationType.TEMPLATE, null){

            @Override
            String serialize(RepresentationFormat format, URI baseUri, ExtensionInjector extensions) {
                return Serializer.joinBaseWithRelativePath(baseUri, path);
            }

            @Override
            void addTo(ListSerializer serializer) {
                serializer.addUriTemplate(path);
            }

            @Override
            void putTo(MappingSerializer serializer, String key) {
                serializer.putUriTemplate(key, path);
            }
        };
    }

    static Representation property(Object property) {
        return PROPERTY_REPRESENTATION.dispatch(property, null);
    }
}

