/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.util.Util;
import apoc.uuid.UuidConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.IterableUtils;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;

public class UuidHandler
extends LifecycleAdapter
implements TransactionEventListener<Void> {
    private final GraphDatabaseAPI db;
    private final Log log;
    private final DatabaseManagementService databaseManagementService;
    private final ApocConfig apocConfig;
    private final ConcurrentHashMap<String, UuidConfig> configuredLabelAndPropertyNames = new ConcurrentHashMap();
    public static final String NOT_ENABLED_ERROR = "UUID have not been enabled. Set 'apoc.uuid.enabled=true' or 'apoc.uuid.enabled.%s=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.";

    public UuidHandler(GraphDatabaseAPI db, DatabaseManagementService databaseManagementService, Log log, ApocConfig apocConfig, GlobalProcedures globalProceduresRegistry) {
        this.db = db;
        this.databaseManagementService = databaseManagementService;
        this.log = log;
        this.apocConfig = apocConfig;
    }

    public void start() {
        if (this.isEnabled()) {
            this.refresh();
            this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    private boolean isEnabled() {
        String apocUUIDEnabledDb = String.format("apoc.uuid.enabled.%s", this.db.databaseName());
        return this.apocConfig.getConfig().getBoolean(apocUUIDEnabledDb, this.apocConfig.getBoolean("apoc.uuid.enabled"));
    }

    public void stop() {
        if (this.isEnabled()) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty) {
        this.checkAndRestoreUuidProperty(nodeProperties, label, uuidProperty, null);
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty, Predicate<PropertyEntry<Node>> predicate) {
        if (nodeProperties.iterator().hasNext()) {
            nodeProperties.forEach(nodePropertyEntry -> {
                if (predicate == null) {
                    if (((Node)nodePropertyEntry.entity()).hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty)) {
                        ((Node)nodePropertyEntry.entity()).setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                    }
                } else if (((Node)nodePropertyEntry.entity()).hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty) && predicate.test((PropertyEntry<Node>)nodePropertyEntry)) {
                    ((Node)nodePropertyEntry.entity()).setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                }
            });
        }
    }

    public Void beforeCommit(TransactionData txData, Transaction transaction, GraphDatabaseService databaseService) {
        Iterable assignedNodeProperties = txData.assignedNodeProperties();
        Iterable removedNodeProperties = txData.removedNodeProperties();
        this.configuredLabelAndPropertyNames.forEach((label, config) -> {
            String propertyName = config.getUuidProperty();
            List<Node> nodes = config.isAddToSetLabels() ? StreamSupport.stream(txData.assignedLabels().spliterator(), false).map(LabelEntry::node).collect(Collectors.toList()) : IterableUtils.toList((Iterable)txData.createdNodes());
            try {
                nodes.forEach(node -> {
                    if (node.hasLabel(Label.label((String)label)) && !node.hasProperty(propertyName)) {
                        String uuid = UUID.randomUUID().toString();
                        node.setProperty(propertyName, (Object)uuid);
                    }
                });
                this.checkAndRestoreUuidProperty(assignedNodeProperties, (String)label, propertyName, nodePropertyEntry -> nodePropertyEntry.value() == null || nodePropertyEntry.value().equals(""));
                this.checkAndRestoreUuidProperty(removedNodeProperties, (String)label, propertyName);
            }
            catch (Exception e) {
                this.log.warn("Error executing uuid " + label + " in phase before", (Throwable)e);
            }
        });
        return null;
    }

    public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    public void afterRollback(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    private void checkEnabled() {
        if (!this.isEnabled()) {
            throw new RuntimeException(String.format(NOT_ENABLED_ERROR, this.db.databaseName()));
        }
    }

    public void checkConstraintUuid(Transaction tx, String label, String propertyName) {
        Schema schema = tx.schema();
        Stream<ConstraintDefinition> constraintDefinitionStream = StreamSupport.stream(schema.getConstraints(Label.label((String)label)).spliterator(), false);
        boolean exists = constraintDefinitionStream.anyMatch(constraint -> {
            Stream<String> streamPropertyKeys = StreamSupport.stream(constraint.getPropertyKeys().spliterator(), false);
            return streamPropertyKeys.anyMatch(property -> property.equals(propertyName));
        });
        if (!exists) {
            String error = String.format("`CREATE CONSTRAINT ON (%s:%s) ASSERT %s.%s IS UNIQUE`", label.toLowerCase(), label, label.toLowerCase(), propertyName);
            throw new RuntimeException("No constraint found for label: " + label + ", please add the constraint with the following : " + error);
        }
    }

    public void add(Transaction tx, String label, UuidConfig config) {
        this.checkEnabled();
        String propertyName = config.getUuidProperty();
        this.checkConstraintUuid(tx, label, propertyName);
        this.configuredLabelAndPropertyNames.put(label, config);
        try (Transaction sysTx = this.apocConfig.getSystemDb().beginTx();){
            Node node = Util.mergeNode((Transaction)sysTx, (Label)SystemLabels.ApocUuid, null, (Pair[])new Pair[]{Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.db.databaseName()), Pair.of((Object)SystemPropertyKeys.label.name(), (Object)label), Pair.of((Object)SystemPropertyKeys.propertyName.name(), (Object)propertyName)});
            sysTx.commit();
        }
    }

    public Map<String, UuidConfig> list() {
        this.checkEnabled();
        return this.configuredLabelAndPropertyNames;
    }

    public void refresh() {
        this.configuredLabelAndPropertyNames.clear();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> {
                UuidConfig config = new UuidConfig(Map.of("uuidProperty", node.getProperty(SystemPropertyKeys.propertyName.name()), "addToSetLabels", node.getProperty(SystemPropertyKeys.addToSetLabel.name())));
                this.configuredLabelAndPropertyNames.put((String)node.getProperty(SystemPropertyKeys.label.name()), config);
            });
            tx.commit();
        }
    }

    public synchronized UuidConfig remove(String label) {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.label.name(), (Object)label).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        return this.configuredLabelAndPropertyNames.remove(label);
    }

    public synchronized Map<String, UuidConfig> removeAll() {
        HashMap<String, UuidConfig> retval = new HashMap<String, UuidConfig>(this.configuredLabelAndPropertyNames);
        this.configuredLabelAndPropertyNames.clear();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        return retval;
    }
}

