/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Extended;
import apoc.Pools;
import apoc.cypher.Cypher;
import apoc.result.MapResult;
import apoc.util.FileUtils;
import apoc.util.MapUtil;
import apoc.util.QueueBasedSpliterator;
import apoc.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

@Extended
public class CypherExtended {
    public static final String COMPILED_PREFIX = "CYPHER runtime=interpreted";
    public static final int PARTITIONS = 100 * Runtime.getRuntime().availableProcessors();
    public static final int MAX_BATCH = 10000;
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFile(file or url,[{statistics:true,timeout:10,parameters:{}}]) - runs each statement in the file, all semicolon separated - currently no schema operations")
    public Stream<RowResult> runFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.cypher.runFiles([files or urls],[{statistics:true,timeout:10,parameters:{}}])) - runs each statement in the files, all semicolon separated")
    public Stream<RowResult> runFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Map<String, Object> parameters = config.getOrDefault("parameters", Collections.emptyMap());
        boolean schemaOperation = false;
        return this.runFiles(fileNames, config, parameters, false);
    }

    private Stream<RowResult> runFiles(List<String> fileNames, Map<String, Object> config, Map<String, Object> parameters, boolean schemaOperation) {
        boolean addStatistics = Util.toBoolean((Object)config.getOrDefault("statistics", true));
        int timeout = Util.toInteger((Object)config.getOrDefault("timeout", 10));
        int queueCapacity = Util.toInteger((Object)config.getOrDefault("queueCapacity", 100));
        ArrayList<Stream> result = new ArrayList<Stream>();
        for (String fileName : fileNames) {
            Reader reader = this.readerForFile(fileName);
            Scanner scanner = this.createScannerFor(reader);
            Stream stream = (Stream)this.runManyStatements(scanner, parameters, schemaOperation, addStatistics, timeout, queueCapacity).onClose(() -> Util.close((AutoCloseable)scanner, e -> this.log.info("Cannot close the scanner for file " + fileName + " because the following exception", (Throwable)e)));
            result.add(stream);
        }
        return result.stream().reduce(Stream::concat).orElse(Stream.empty());
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFile(file or url,[{statistics:true,timeout:10}]) - allows only schema operations, runs each schema statement in the file, all semicolon separated")
    public Stream<RowResult> runSchemaFile(@Name(value="file") String fileName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.runSchemaFiles(Collections.singletonList(fileName), config);
    }

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.cypher.runSchemaFiles([files or urls],{statistics:true,timeout:10}) - allows only schema operations, runs each schema statement in the files, all semicolon separated")
    public Stream<RowResult> runSchemaFiles(@Name(value="file") List<String> fileNames, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        boolean schemaOperation = true;
        Map<String, Object> parameters = Collections.emptyMap();
        return this.runFiles(fileNames, config, parameters, true);
    }

    private Stream<RowResult> runManyStatements(Scanner scanner, Map<String, Object> params, boolean schemaOperation, boolean addStatistics, int timeout, int queueCapacity) {
        BlockingQueue<RowResult> queue = this.runInSeparateThreadAndSendTombstone(queueCapacity, internalQueue -> {
            if (schemaOperation) {
                this.runSchemaStatementsInTx(scanner, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout);
            } else {
                this.runDataStatementsInTx(scanner, (BlockingQueue<RowResult>)internalQueue, params, addStatistics, timeout);
            }
        }, RowResult.TOMBSTONE);
        return StreamSupport.stream(new QueueBasedSpliterator(queue, (Object)RowResult.TOMBSTONE, this.terminationGuard, Integer.MAX_VALUE), false);
    }

    private <T> BlockingQueue<T> runInSeparateThreadAndSendTombstone(int queueCapacity, Consumer<BlockingQueue<T>> action, T tombstone) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(queueCapacity);
        Util.newDaemonThread(() -> {
            try {
                action.accept(queue);
            }
            finally {
                while (true) {
                    try {
                        queue.put(tombstone);
                        return;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
            }
        }).start();
        return queue;
    }

    private void runDataStatementsInTx(Scanner scanner, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout) {
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || this.isSchemaOperation(stmt)) continue;
            if (this.isPeriodicOperation(stmt)) {
                Util.inThread((Pools)this.pools, () -> this.db.executeTransactionally(stmt, params, result -> this.consumeResult((Result)result, queue, addStatistics, timeout)));
                continue;
            }
            Util.inTx((GraphDatabaseService)this.db, (Pools)this.pools, threadTx -> {
                try (Result result = threadTx.execute(stmt, params);){
                    Object object = this.consumeResult(result, queue, addStatistics, timeout);
                    return object;
                }
            });
        }
    }

    private Scanner createScannerFor(Reader reader) {
        Scanner scanner = new Scanner(reader);
        scanner.useDelimiter(";\r?\n");
        return scanner;
    }

    private void runSchemaStatementsInTx(Scanner scanner, BlockingQueue<RowResult> queue, Map<String, Object> params, boolean addStatistics, long timeout) {
        while (scanner.hasNext()) {
            String stmt = this.removeShellControlCommands(scanner.next());
            if (stmt.trim().isEmpty() || !this.isSchemaOperation(stmt)) continue;
            Util.inTx((GraphDatabaseService)this.db, (Pools)this.pools, txInThread -> {
                try (Result result = txInThread.execute(stmt, params);){
                    Object object = this.consumeResult(result, queue, addStatistics, timeout);
                    return object;
                }
            });
        }
    }

    private Object consumeResult(Result result, BlockingQueue<RowResult> queue, boolean addStatistics, long timeout) {
        try {
            long time = System.currentTimeMillis();
            int row = 0;
            while (result.hasNext()) {
                this.terminationGuard.check();
                queue.put(new RowResult(row++, result.next()));
            }
            if (addStatistics) {
                queue.put(new RowResult(-1L, this.toMap(result.getQueryStatistics(), System.currentTimeMillis() - time, row)));
            }
            return row;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            return this.removeShellControlCommands(matcher.replaceAll(""));
        }
        return stmt;
    }

    private boolean isSchemaOperation(String stmt) {
        return stmt.matches("(?is).*(create|drop)\\s+(index|constraint).*");
    }

    private boolean isPeriodicOperation(String stmt) {
        return stmt.matches("(?is).*using\\s+periodic.*");
    }

    private Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        return MapUtil.map((Object[])new Object[]{"rows", rows, "time", time, "nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved()});
    }

    private Reader readerForFile(@Name(value="file") String fileName) {
        try {
            return FileUtils.readerFor((String)fileName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error accessing file " + fileName, ioe);
        }
    }

    public static String withParamMapping(String fragment, Collection<String> keys) {
        if (keys.isEmpty()) {
            return fragment;
        }
        String declaration = " WITH " + String.join((CharSequence)", ", keys.stream().map(s -> String.format(" $`%s` as `%s` ", s, s)).collect(Collectors.toList()));
        return declaration + fragment;
    }

    public static String compiled(String fragment) {
        return fragment.substring(0, 6).equalsIgnoreCase("cypher") ? fragment : COMPILED_PREFIX + fragment;
    }

    @Procedure
    public Stream<MapResult> parallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return Cypher.runCypherQuery((Transaction)this.tx, (String)fragment, params);
        }
        if (key == null || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + params.keySet());
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + value);
        }
        String statement = CypherExtended.withParamMapping(fragment, params.keySet());
        Collection coll = (Collection)value;
        return coll.parallelStream().flatMap(v -> {
            this.terminationGuard.check();
            HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
            parallelParams.replace(key, v);
            return this.tx.execute(statement, parallelParams).stream().map(MapResult::new);
        });
    }

    @Procedure
    @Description(value="apoc.cypher.mapParallel(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data) {
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), "_");
        this.tx.execute("EXPLAIN " + statement).close();
        return Util.partitionSubList(data, (int)PARTITIONS, null).flatMap(partition -> ((ArrayList)Iterators.addToCollection((Iterator)this.tx.execute(statement, this.parallelParams(params, "_", (List<Object>)partition)), new ArrayList(partition.size()))).stream()).map(MapResult::new);
    }

    @Procedure
    @Description(value="apoc.cypher.mapParallel2(fragment, params, list-to-parallelize) yield value - executes fragment in parallel batches with the list segments being assigned to _")
    public Stream<MapResult> mapParallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="list") List<Object> data, @Name(value="partitions") long partitions, @Name(value="timeout", defaultValue="10") long timeout) {
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), "_");
        this.tx.execute("EXPLAIN " + statement).close();
        ArrayBlockingQueue queue = new ArrayBlockingQueue(100000);
        Stream parallelPartitions = Util.partitionSubList(data, (int)((int)(partitions <= 0L ? (long)PARTITIONS : partitions)), null);
        Util.inFuture((Pools)this.pools, () -> {
            long total = parallelPartitions.map(partition -> {
                try (Transaction transaction = this.db.beginTx();){
                    Object object;
                    block14: {
                        Result result = transaction.execute(statement, this.parallelParams(params, "_", (List<Object>)partition));
                        try {
                            object = this.consumeResult(result, queue, false, timeout);
                            if (result == null) break block14;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return object;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).count();
            queue.put(RowResult.TOMBSTONE);
            return total;
        });
        return StreamSupport.stream(new QueueBasedSpliterator(queue, (Object)RowResult.TOMBSTONE, this.terminationGuard, (int)timeout), true).map(rowResult -> new MapResult(rowResult.result));
    }

    public Map<String, Object> parallelParams(@Name(value="params") Map<String, Object> params, String key, List<Object> partition) {
        if (params.isEmpty()) {
            return Collections.singletonMap(key, partition);
        }
        HashMap<String, Object> parallelParams = new HashMap<String, Object>(params);
        parallelParams.put(key, partition);
        return parallelParams;
    }

    @Procedure
    public Stream<MapResult> parallel2(@Name(value="fragment") String fragment, @Name(value="params") Map<String, Object> params, @Name(value="parallelizeOn") String key) {
        if (params == null) {
            return Cypher.runCypherQuery((Transaction)this.tx, (String)fragment, params);
        }
        if (key == null || !params.containsKey(key)) {
            throw new RuntimeException("Can't parallelize on key " + key + " available keys " + params.keySet());
        }
        Object value = params.get(key);
        if (!(value instanceof Collection)) {
            throw new RuntimeException("Can't parallelize a non collection " + key + " : " + value);
        }
        String statement = CypherExtended.withParamsAndIterator(fragment, params.keySet(), key);
        this.tx.execute("EXPLAIN " + statement).close();
        Collection coll = (Collection)value;
        int total = coll.size();
        int partitions = PARTITIONS;
        int batchSize = Math.max(total / partitions, 1);
        if (batchSize > 10000) {
            batchSize = 10000;
            partitions = total / batchSize + 1;
        }
        ArrayList<Future<List<Map<String, Object>>>> futures = new ArrayList<Future<List<Map<String, Object>>>>(partitions);
        ArrayList<Object> partition = new ArrayList<Object>(batchSize);
        for (Object o : coll) {
            partition.add(o);
            if (partition.size() != batchSize) continue;
            futures.add(this.submit(this.db, statement, params, key, partition, this.terminationGuard));
            partition = new ArrayList(batchSize);
        }
        if (!partition.isEmpty()) {
            futures.add(this.submit(this.db, statement, params, key, partition, this.terminationGuard));
        }
        return futures.stream().flatMap(f -> {
            try {
                return ((List)f.get()).stream().map(MapResult::new);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error executing in parallel " + statement, e);
            }
        });
    }

    public static String withParamsAndIterator(String fragment, Collection<String> params, String iterator) {
        boolean noIterator;
        boolean bl = noIterator = iterator == null || iterator.isEmpty();
        if (params.isEmpty() && noIterator) {
            return fragment;
        }
        String with = Util.withMapping(params.stream().filter(c -> noIterator || !c.equals(iterator)), c -> Util.param((String)c) + " AS " + Util.quote((String)c));
        if (noIterator) {
            return with + fragment;
        }
        return with + " UNWIND " + Util.param((String)iterator) + " AS " + Util.quote((String)iterator) + " " + fragment;
    }

    private Future<List<Map<String, Object>>> submit(GraphDatabaseService db, String statement, Map<String, Object> params, String key, List<Object> partition, TerminationGuard terminationGuard) {
        return this.pools.getDefaultExecutorService().submit(() -> {
            terminationGuard.check();
            return (List)db.executeTransactionally(statement, this.parallelParams(params, key, partition), result -> Iterators.asList((Iterator)result));
        });
    }

    public static class RowResult {
        public static final RowResult TOMBSTONE = new RowResult(-1L, null);
        public long row;
        public Map<String, Object> result;

        public RowResult(long row, Map<String, Object> result) {
            this.row = row;
            this.result = result;
        }
    }
}

