/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.tooling.procedure.messages.AggregationError;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.visitors.FunctionVisitor;
import org.neo4j.tooling.procedure.visitors.QualifiedTypeVisitor;

public class UserAggregationFunctionVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final FunctionVisitor<UserAggregationFunction> functionVisitor;
    private final Types types;
    private final ElementVisitor<CharSequence, Void> typeVisitor;

    public UserAggregationFunctionVisitor(FunctionVisitor<UserAggregationFunction> baseFunctionVisitor, Types types) {
        this.functionVisitor = baseFunctionVisitor;
        this.types = types;
        this.typeVisitor = new QualifiedTypeVisitor();
    }

    @Override
    public Stream<CompilationMessage> visitExecutable(ExecutableElement aggregationFunction, Void ignored) {
        return Stream.of(this.functionVisitor.validateEnclosingClass(aggregationFunction), this.validateParameters(aggregationFunction, UserAggregationFunction.class), this.functionVisitor.validateName(aggregationFunction), this.validateAggregationType(aggregationFunction)).flatMap(Function.identity());
    }

    private Stream<CompilationMessage> validateAggregationType(ExecutableElement aggregationFunction) {
        TypeMirror returnType = aggregationFunction.getReturnType();
        Element returnTypeElement = this.types.asElement(returnType);
        if (returnTypeElement == null) {
            return Stream.of(new AggregationError(aggregationFunction, "Unsupported return type <%s> of aggregation function.", returnType.toString(), aggregationFunction.getEnclosingElement()));
        }
        List<ExecutableElement> updateMethods = this.methodsAnnotatedWith(returnTypeElement, UserAggregationUpdate.class);
        List<ExecutableElement> resultMethods = this.methodsAnnotatedWith(returnTypeElement, UserAggregationResult.class);
        return Stream.concat(this.validateAggregationUpdateMethod(aggregationFunction, returnTypeElement, updateMethods), this.validateAggregationResultMethod(aggregationFunction, returnTypeElement, resultMethods));
    }

    private List<ExecutableElement> methodsAnnotatedWith(Element returnType, Class<? extends Annotation> annotationType) {
        return ElementFilter.methodsIn(returnType.getEnclosedElements()).stream().filter(m -> m.getAnnotation(annotationType) != null).collect(Collectors.toList());
    }

    private Stream<CompilationMessage> validateAggregationUpdateMethod(ExecutableElement aggregationFunction, Element returnType, List<ExecutableElement> updateMethods) {
        if (updateMethods.size() != 1) {
            return Stream.of(this.missingAnnotation(aggregationFunction, returnType, updateMethods, UserAggregationUpdate.class));
        }
        Stream<Object> errors = Stream.empty();
        ExecutableElement updateMethod = updateMethods.iterator().next();
        if (!this.isValidUpdateSignature(updateMethod)) {
            errors = Stream.of(new AggregationError(updateMethod, "@%s usage error: method should be public, non-static and define 'void' as return type.", UserAggregationUpdate.class.getSimpleName()));
        }
        return Stream.concat(errors, this.functionVisitor.validateParameters(updateMethod.getParameters()));
    }

    private Stream<CompilationMessage> validateAggregationResultMethod(ExecutableElement aggregationFunction, Element returnType, List<ExecutableElement> resultMethods) {
        if (resultMethods.size() != 1) {
            return Stream.of(this.missingAnnotation(aggregationFunction, returnType, resultMethods, UserAggregationResult.class));
        }
        ExecutableElement resultMethod = resultMethods.iterator().next();
        return Stream.concat(this.validateParameters(resultMethod, UserAggregationUpdate.class), this.functionVisitor.validateReturnType(resultMethod));
    }

    private Stream<CompilationMessage> validateParameters(ExecutableElement resultMethod, Class<? extends Annotation> annotation) {
        if (!this.isValidAggregationSignature(resultMethod)) {
            return Stream.of(new AggregationError(resultMethod, "@%s usage error: method should be public, non-static and without parameters.", annotation.getSimpleName()));
        }
        return Stream.empty();
    }

    private AggregationError missingAnnotation(ExecutableElement aggregationFunction, Element returnType, List<ExecutableElement> updateMethods, Class<? extends Annotation> annotation) {
        return new AggregationError(aggregationFunction, "@%s usage error: expected aggregation type <%s> to define exactly 1 method with this annotation. %s.", annotation.getSimpleName(), this.typeVisitor.visit(returnType), updateMethods.isEmpty() ? "Found none" : "Several methods found: " + this.methodNames(updateMethods));
    }

    private boolean isValidUpdateSignature(ExecutableElement updateMethod) {
        return this.isPublicNonStatic(updateMethod.getModifiers()) && updateMethod.getReturnType().getKind().equals((Object)TypeKind.VOID);
    }

    private boolean isValidAggregationSignature(ExecutableElement resultMethod) {
        return this.isPublicNonStatic(resultMethod.getModifiers()) && resultMethod.getParameters().isEmpty();
    }

    private boolean isPublicNonStatic(Set<Modifier> modifiers) {
        return modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
    }

    private String methodNames(List<ExecutableElement> updateMethods) {
        return updateMethods.stream().map(ExecutableElement::getSimpleName).collect(Collectors.joining(","));
    }
}

