/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.ExtensionMissingPublicNoArgConstructor;
import org.neo4j.tooling.procedure.visitors.FieldVisitor;

public class ExtensionClassVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final Set<TypeElement> visitedElements = new HashSet<TypeElement>();
    private final FieldVisitor fieldVisitor;

    public ExtensionClassVisitor(Types types, Elements elements, boolean ignoresWarnings) {
        this.fieldVisitor = new FieldVisitor(types, elements, ignoresWarnings);
    }

    @Override
    public Stream<CompilationMessage> visitType(TypeElement extensionClass, Void ignored) {
        if (this.isFirstVisit(extensionClass)) {
            return Stream.concat(this.validateFields(extensionClass), this.validateConstructor(extensionClass));
        }
        return Stream.empty();
    }

    private boolean isFirstVisit(TypeElement e) {
        return this.visitedElements.add(e);
    }

    private Stream<CompilationMessage> validateFields(TypeElement e) {
        return e.getEnclosedElements().stream().flatMap(this.fieldVisitor::visit);
    }

    private Stream<CompilationMessage> validateConstructor(Element extensionClass) {
        Optional<ExecutableElement> publicNoArgConstructor = ElementFilter.constructorsIn(extensionClass.getEnclosedElements()).stream().filter(c -> c.getModifiers().contains((Object)Modifier.PUBLIC)).filter(c -> c.getParameters().isEmpty()).findFirst();
        if (!publicNoArgConstructor.isPresent()) {
            return Stream.of(new ExtensionMissingPublicNoArgConstructor(extensionClass, "Extension class %s should contain a public no-arg constructor, none found.", extensionClass));
        }
        return Stream.empty();
    }
}

