/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.procedure.visitors;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import org.neo4j.procedure.Name;
import org.neo4j.tooling.procedure.compilerutils.TypeMirrorUtils;
import org.neo4j.tooling.procedure.messages.CompilationMessage;
import org.neo4j.tooling.procedure.messages.ReturnTypeError;
import org.neo4j.tooling.procedure.visitors.AnnotationTypeVisitor;
import org.neo4j.tooling.procedure.visitors.ParameterTypeVisitor;
import org.neo4j.tooling.procedure.visitors.ParameterVisitor;
import org.neo4j.tooling.procedure.visitors.RecordTypeVisitor;
import org.neo4j.tooling.procedure.visitors.StoredProcedureClassVisitor;

public class StoredProcedureVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final ElementVisitor<Stream<CompilationMessage>, Void> classVisitor;
    private final TypeVisitor<Stream<CompilationMessage>, Void> recordVisitor;
    private final ElementVisitor<Stream<CompilationMessage>, Void> parameterVisitor;

    public StoredProcedureVisitor(Types typeUtils, Elements elementUtils, boolean skipContextWarnings) {
        TypeMirrorUtils typeMirrors = new TypeMirrorUtils(typeUtils, elementUtils);
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.classVisitor = new StoredProcedureClassVisitor(typeUtils, elementUtils, skipContextWarnings);
        this.recordVisitor = new RecordTypeVisitor(typeUtils, typeMirrors);
        this.parameterVisitor = new ParameterVisitor(new ParameterTypeVisitor(typeUtils, typeMirrors));
    }

    @Override
    public Stream<CompilationMessage> visitExecutable(ExecutableElement executableElement, Void ignored) {
        return Stream.of(this.classVisitor.visit(executableElement.getEnclosingElement()), this.validateParameters(executableElement.getParameters(), ignored), this.validateReturnType(executableElement)).flatMap(Function.identity());
    }

    private Stream<CompilationMessage> validateParameters(List<? extends VariableElement> parameters, Void ignored) {
        return parameters.stream().flatMap(var -> this.parameterVisitor.visit((Element)var, ignored));
    }

    private Stream<CompilationMessage> validateReturnType(ExecutableElement method) {
        String streamClassName = Stream.class.getCanonicalName();
        TypeMirror streamType = this.typeUtils.erasure(this.elementUtils.getTypeElement(streamClassName).asType());
        TypeMirror returnType = method.getReturnType();
        TypeMirror erasedReturnType = this.typeUtils.erasure(returnType);
        NoType voidType = this.typeUtils.getNoType(TypeKind.VOID);
        if (this.typeUtils.isSameType(returnType, voidType)) {
            return Stream.empty();
        }
        if (!this.typeUtils.isSubtype(erasedReturnType, streamType)) {
            return Stream.of(new ReturnTypeError(method, "Return type of %s#%s must be %s", method.getEnclosingElement().getSimpleName(), method.getSimpleName(), streamClassName));
        }
        return this.recordVisitor.visit(returnType);
    }

    private AnnotationMirror annotationMirror(List<? extends AnnotationMirror> mirrors) {
        AnnotationTypeVisitor nameVisitor = new AnnotationTypeVisitor(Name.class);
        return mirrors.stream().filter(mirror -> (Boolean)nameVisitor.visit(mirror.getAnnotationType().asElement())).findFirst().orElse(null);
    }

    private String nameOf(VariableElement parameter) {
        return parameter.getSimpleName().toString();
    }
}

