/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalTime;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class LocalTimeArray
extends TemporalArray<LocalTime> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LocalTimeArray.class);
    private final LocalTime[] value;

    LocalTimeArray(LocalTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        LocalTimeArray.writeTo(writer, ValueWriter.ArrayType.LOCAL_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((LocalTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "LocalTimeArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)HeapEstimator.LOCAL_TIME_SIZE, (int)this.value.length);
    }
}

