/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;

enum Neo4JTemporalField implements TemporalField
{
    YEAR_OF_DECADE("Year of decade", ChronoUnit.YEARS, ChronoUnit.DECADES, 10),
    YEAR_OF_CENTURY("Year of century", ChronoUnit.YEARS, ChronoUnit.CENTURIES, 100),
    YEAR_OF_MILLENNIUM("Millennium", ChronoUnit.YEARS, ChronoUnit.MILLENNIA, 1000);

    private final String name;
    private final TemporalUnit baseUnit;
    private final TemporalUnit rangeUnit;
    private final int years;
    private final ValueRange range;

    private Neo4JTemporalField(String name, TemporalUnit baseUnit, TemporalUnit rangeUnit, int years) {
        this.name = name;
        this.baseUnit = baseUnit;
        this.rangeUnit = rangeUnit;
        this.years = years;
        this.range = ValueRange.of(-999999999 / years, 999999999 / years);
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.name;
    }

    @Override
    public TemporalUnit getBaseUnit() {
        return this.baseUnit;
    }

    @Override
    public TemporalUnit getRangeUnit() {
        return this.rangeUnit;
    }

    @Override
    public ValueRange range() {
        return this.range;
    }

    @Override
    public boolean isDateBased() {
        return true;
    }

    @Override
    public boolean isTimeBased() {
        return false;
    }

    @Override
    public boolean isSupportedBy(TemporalAccessor temporal) {
        return false;
    }

    @Override
    public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
        return this.range();
    }

    @Override
    public long getFrom(TemporalAccessor temporal) {
        throw new UnsupportedOperationException("Getting a " + this.name + " from temporal values is not supported.");
    }

    @Override
    public <R extends Temporal> R adjustInto(R temporal, long newValue) {
        int newVal = this.range.checkValidIntValue(newValue, this);
        int oldYear = temporal.get(ChronoField.YEAR);
        return (R)temporal.with(ChronoField.YEAR, oldYear / this.years * this.years + newVal).with(TemporalAdjusters.firstDayOfYear());
    }

    @Override
    public String toString() {
        return this.name;
    }
}

