/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.Comparator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValueGroup;

public abstract class VirtualValue
extends AnyValue {
    @Override
    public final boolean equalTo(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof SequenceValue && this.isSequenceValue()) {
            return ((SequenceValue)((Object)this)).equals((SequenceValue)other);
        }
        return other instanceof VirtualValue && this.equals((VirtualValue)other);
    }

    public abstract boolean equals(VirtualValue var1);

    @Override
    public Equality ternaryEquals(AnyValue other) {
        assert (other != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (other == Values.NO_VALUE) {
            return Equality.UNDEFINED;
        }
        if (other instanceof SequenceValue && this.isSequenceValue()) {
            return ((SequenceValue)((Object)this)).ternaryEquality((SequenceValue)((Object)other));
        }
        if (other instanceof VirtualValue && ((VirtualValue)other).valueGroup() == this.valueGroup()) {
            return this.equals((VirtualValue)other) ? Equality.TRUE : Equality.FALSE;
        }
        return Equality.FALSE;
    }

    public abstract VirtualValueGroup valueGroup();

    public abstract int unsafeCompareTo(VirtualValue var1, Comparator<AnyValue> var2);

    public abstract Comparison unsafeTernaryCompareTo(VirtualValue var1, TernaryComparator<AnyValue> var2);
}

