/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.ValueWriter;

public final class DoubleValue
extends FloatingPointValue {
    private final double value;

    DoubleValue(double value) {
        this.value = value;
    }

    public double value() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloatingPoint(this.value);
    }

    @Override
    public Double asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Double.toString(this.value);
    }

    public String toString() {
        return String.format("Double(%e)", this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDouble(this);
    }
}

