/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.ZonedDateTime;
import java.util.Arrays;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

public class DateTimeArray
extends TemporalArray<ZonedDateTime, DateTimeValue> {
    private final ZonedDateTime[] value;

    DateTimeArray(ZonedDateTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected ZonedDateTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(ZonedDateTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.ZONED_DATE_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_DATE_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateTimeArray)otherValue);
    }
}

