/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Comparator;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class ValueComparator
implements Comparator<Value>,
TernaryComparator<Value> {
    private final Comparator<ValueGroup> valueGroupComparator;

    ValueComparator(Comparator<ValueGroup> valueGroupComparator) {
        this.valueGroupComparator = valueGroupComparator;
    }

    @Override
    public int compare(Value v1, Value v2) {
        ValueGroup id2;
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        ValueGroup id1 = v1.valueGroup();
        int x = this.valueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.unsafeCompareTo(v2);
        }
        return x;
    }

    @Override
    public Integer ternaryCompare(Value v1, Value v2) {
        ValueGroup id2;
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        ValueGroup id1 = v1.valueGroup();
        int x = this.valueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.unsafeTernaryCompareTo(v2);
        }
        return x;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ValueComparator;
    }

    public int hashCode() {
        return 1;
    }
}

